package com.thebeastshop.payment.service;

import com.thebeastshop.payment.vo.PPaymentTradeVO;

import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-12-20 19:42
 */
public interface PPaymentTradeService {


    /**
     * 根据流水号查询支付信息
     *
     * @param tradeCode
     * @return
     */
    PPaymentTradeVO getTradeByTradeCode(String tradeCode);

    /**
     * 根据第三方支付平台流水号查询支付信息
     *
     * @param thirdPartyTradeCode
     * @return
     */
    PPaymentTradeVO getTradeByThirdPartyTradeCode(String thirdPartyTradeCode);

    /**
     * 根据外部流水号查询流水记录
     *
     * @param outTradeCode
     * @return
     */
    List<PPaymentTradeVO> getTradeListByOutTradeCode(String outTradeCode);

    /**
     * 根据会员Id查询相关支付流水记录
     * @param memberId
     * @return
     */
    List<PPaymentTradeVO> getTradeListByMemberId(Long memberId);

}
