package com.thebeastshop.payment.dto;

import java.util.List;

import com.thebeastshop.payment.enums.PPaymentChannelEnum;

/**
 * 礼品卡支付渠道
 * @Class Name PGiftCardPaymentDTO
 * @Author Xiang.Gao
 * @Create In 2017-12-19
 */
public class PGiftCardPaymentDTO extends PPaymentDTO{

	/**
	 * 卡信息 JSON字符串 	
	 * 示例
	 * [
	 * 	{"cardNo":"2014121206512","consumeAmount":"100"},
	 *  {"cardNo":"2014121206513","consumeAmount":"200"}
	 * ]
	 * @Field String cardInfoJson 
	 */
	private String cardInfoJson;
	
	/**
	 * 类目ID 集合
	 * @Field List<Integer> categoryIds 
	 */
	private List<Integer> categoryIds;
	
	/**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;

	public PGiftCardPaymentDTO() {
		super(PPaymentChannelEnum.GIFT_CARD);
	}

	@Override
	public String getPaymentBusinessCode() {
		// TODO Auto-generated method stub
		return null;
	}

	public List<Integer> getCategoryIds() {
		return categoryIds;
	}

	public void setCategoryIds(List<Integer> categoryIds) {
		this.categoryIds = categoryIds;
	}

	public String getCardInfoJson() {
		return cardInfoJson;
	}

	public void setCardInfoJson(String cardInfoJson) {
		this.cardInfoJson = cardInfoJson;
	}

}
