/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.exception;

import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.op.exception.OperationException;

public class OperationExceptionAssert {
    public static void isEmpty(Object object, String errorMsg) {
        OperationExceptionAssert.isEmpty(object, "OP0001", errorMsg);
    }

    public static void isEmpty(Object object, String errorCode, String errorMsg) {
        if (EmptyUtil.isNotEmpty((Object)object)) {
            throw new OperationException(errorCode, errorMsg);
        }
    }

    public static void isNotEmpty(Object object, String errorMsg) {
        OperationExceptionAssert.isNotEmpty(object, "OP0001", errorMsg);
    }

    public static void isNotEmpty(Object object, String errorCode, String errorMsg) {
        if (EmptyUtil.isEmpty((Object)object)) {
            throw new OperationException(errorCode, errorMsg);
        }
    }

    public static void isTrue(boolean result, String errorMsg) {
        if (!result) {
            throw new OperationException("OP0004", errorMsg);
        }
    }

    public static void isTrue(boolean result) {
        OperationExceptionAssert.isTrue(result, "\u7ed3\u679c\u4e0d\u7b26\u5408\u9884\u671f");
    }

    public static void isTrue(Integer result) {
        OperationExceptionAssert.isTrue(!NumberUtil.isNullOrZero((Number)result));
    }

    public static void isTrue(Integer result, String errorMsg) {
        OperationExceptionAssert.isTrue(!NumberUtil.isNullOrZero((Number)result), errorMsg);
    }

    public static void equalsStatus(String errorMsg, Integer status, Integer ... anotherStatus) {
        if (anotherStatus.length == 0) {
            if (!anotherStatus.equals(status)) {
                throw new OperationException("OP0002", errorMsg);
            }
        } else {
            Boolean flag = false;
            for (Integer another : anotherStatus) {
                if (!another.equals(status)) continue;
                flag = true;
            }
            if (!flag.booleanValue()) {
                throw new OperationException("OP0002", errorMsg);
            }
        }
    }

    public static void equalsStatus(Integer status, Integer ... anotherStatus) {
        OperationExceptionAssert.equalsStatus("\u72b6\u6001\u4e0d\u7b26\u5408\u9884\u671f", status, anotherStatus);
    }

    public static void notEqualsStatus(String errorMsg, Integer status, Integer ... anotherStatus) {
        for (Integer another : anotherStatus) {
            if (!another.equals(status)) continue;
            throw new OperationException("OP0002", errorMsg);
        }
    }

    public static void notEqualsStatus(Integer status, Integer ... anotherStatus) {
        OperationExceptionAssert.notEqualsStatus("\u72b6\u6001\u4e0d\u7b26\u5408\u9884\u671f", status, anotherStatus);
    }
}

