/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.pay.util;

import com.thebeastshop.op.vo.BaseTransfer;
import com.thebeastshop.op.vo.CEB311Message;
import com.thebeastshop.op.vo.CrossBorderOrderGoodVO;
import com.thebeastshop.op.vo.CrossBorderOrderVO;
import com.thebeastshop.op.vo.DeclarCustomForAliPay;
import com.thebeastshop.op.vo.GoldjetOrderVO;
import com.thebeastshop.op.vo.Order;
import com.thebeastshop.op.vo.OrderHead;
import com.thebeastshop.op.vo.OrderList;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class CustomsInterfaceParamUtil {
    public static final Logger log = Logger.getLogger(CustomsInterfaceParamUtil.class);

    public CEB311Message buildParam(GoldjetOrderVO goldjetOrder, List<CrossBorderOrderGoodVO> goodList) {
        CEB311Message obj = new CEB311Message();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String apptime = sdf.format(new Date());
        Order order = new Order();
        OrderHead orderHead = new OrderHead();
        ArrayList<OrderList> orderList = new ArrayList<OrderList>();
        BaseTransfer base = new BaseTransfer();
        try {
            BigDecimal goodsValue = new BigDecimal(0);
            BigDecimal freight = new BigDecimal(0);
            BigDecimal discount = new BigDecimal(0);
            BigDecimal taxTotal = new BigDecimal(0);
            BigDecimal acturalPaid = new BigDecimal(0);
            if (CollectionUtils.isNotEmpty(goodList)) {
                for (int i = 0; i < goodList.size(); ++i) {
                    BigDecimal num = new BigDecimal(goodList.get(i).getGoodsNum());
                    BigDecimal So = goodList.get(i).getVatRate().add(goodList.get(i).getSaleTax()).multiply(new BigDecimal(0.01)).divide(new BigDecimal(1).subtract(goodList.get(i).getSaleTax().multiply(new BigDecimal(0.01))), 6, 4).multiply(new BigDecimal(0.7)).setScale(6, 4);
                    BigDecimal P = goodList.get(i).getActuralPaid().add(goodList.get(i).getCustomsDiscount()).setScale(6, 4);
                    BigDecimal B = goodList.get(i).getFreight().setScale(6, 4);
                    BigDecimal totalB = B.multiply(num).setScale(6, 4);
                    BigDecimal A = P.divide(So.add(new BigDecimal(1)), 6, 4).subtract(B).setScale(6, 4);
                    BigDecimal totalA = A.multiply(num).setScale(6, 4);
                    BigDecimal S = A.add(B).multiply(So).setScale(6, 4);
                    BigDecimal totalS = S.multiply(num).setScale(6, 4);
                    BigDecimal L = goodList.get(i).getCustomsDiscount().setScale(6, 4);
                    BigDecimal totalL = L.multiply(num).setScale(6, 4);
                    goodsValue = goodsValue.add(totalA);
                    freight = freight.add(totalB);
                    discount = discount.add(totalL);
                    taxTotal = taxTotal.add(totalS);
                    acturalPaid = acturalPaid.add(goodList.get(i).getActuralPaid().multiply(num)).setScale(6, 4);
                    OrderList orderGoods = new OrderList();
                    orderGoods.setGnum(i + 1 + "");
                    orderGoods.setItemNo(goodList.get(i).getSkuCode() + "");
                    orderGoods.setItemName(goodList.get(i).getGoodsName() + "");
                    orderGoods.setItemDescribe(goodList.get(i).getGoodsName() + "");
                    orderGoods.setBarCode(goodList.get(i).getGoodsBarcode() + "");
                    orderGoods.setUnit(goodList.get(i).getGoodsUnitcode() + "");
                    orderGoods.setQty(goodList.get(i).getGoodsNum() + "");
                    orderGoods.setPrice(A.setScale(3, 4) + "");
                    orderGoods.setTotalPrice(A.multiply(new BigDecimal(goodList.get(i).getGoodsNum())).setScale(3, 4) + "");
                    orderGoods.setCurrency("142");
                    orderGoods.setCountry(goodList.get(i).getYcgCode() + "");
                    orderGoods.setNote(goodList.get(i).getGoodsName() + "");
                    orderList.add(orderGoods);
                    base.setCopCode("3109966673");
                    base.setCopName("\u4e0a\u6d77\u91ce\u6d3e\u7535\u5b50\u5546\u52a1\u6709\u9650\u516c\u53f8");
                    base.setDxpMode("DXP");
                    base.setDxpId("DXPENTTEST510001");
                    base.setNote("www.thebeastshop.com");
                }
            }
            orderHead.setGuid("4CDE1CFD-EDED-46B1-946C-B8022E42FC94");
            orderHead.setAppType("1");
            orderHead.setAppTime(apptime);
            orderHead.setAppStatus("2");
            orderHead.setOrderType("I");
            orderHead.setOrderNo(goldjetOrder.getOrder_sn());
            orderHead.setEbpCode("3109966673");
            orderHead.setEbpName("\u4e0a\u6d77\u91ce\u6d3e\u7535\u5b50\u5546\u52a1\u6709\u9650\u516c\u53f8");
            orderHead.setEbcCode("3109966673");
            orderHead.setEbcName("\u4e0a\u6d77\u91ce\u6d3e\u7535\u5b50\u5546\u52a1\u6709\u9650\u516c\u53f8");
            orderHead.setGoodsValue(goodsValue.setScale(3, 4) + "");
            orderHead.setFreight(freight.setScale(3, 4) + "");
            orderHead.setDiscount(discount.setScale(3, 4) + "");
            orderHead.setTaxTotal(taxTotal.setScale(3, 4) + "");
            orderHead.setActuralPaid(acturalPaid.setScale(3, 4) + "");
            orderHead.setCurrency("142");
            orderHead.setBuyerRegNo(goldjetOrder.getBuyer_name());
            orderHead.setBuyerName(goldjetOrder.getBuyer_name());
            orderHead.setBuyerIdType("1");
            orderHead.setBuyerIdNumber(goldjetOrder.getBuyer_idcard());
            orderHead.setPayCode("");
            orderHead.setPayName("\u652f\u4ed8\u5b9d");
            orderHead.setPayTransactionId(goldjetOrder.getPay_no());
            orderHead.setBatchNumbers("");
            orderHead.setConsignee(goldjetOrder.getBuyer_name());
            orderHead.setConsigneeTelephone(goldjetOrder.getBuyer_phone());
            orderHead.setConsigneeAddress(goldjetOrder.getBuyer_address());
            orderHead.setConsigneeDistrict(goldjetOrder.getProvince_code());
            orderHead.setNote(goldjetOrder.getMain_desc());
        }
        catch (Exception e) {
            log.warn((Object)"\u751f\u4ea7\u62a5\u5173xml\u5f02\u5e38={}", (Throwable)e);
        }
        order.setOrderHead(orderHead);
        order.setOrderList(orderList);
        obj.setOrder(order);
        obj.setBaseTransfer(base);
        obj.setGuid("556E1CFD-EDED-46B1-946C-B8022E42FC94");
        obj.setVersion("1.0");
        obj.setXsi("http://www.w3.org/2001/XMLSchema-instance");
        obj.setCeb("http://www.chinaport.gov.cn/ceb");
        return obj;
    }

    public DeclarCustomForAliPay buildParamForAliPay(CrossBorderOrderVO personOrder) {
        String packageCode = "SO001076000708372401A";
        String tradeNo = "2020040122001394701402628685";
        String saleMoney = "250.00";
        DeclarCustomForAliPay obj = new DeclarCustomForAliPay();
        obj.setService("alipay.acquire.customs");
        obj.setPartner("2088421407542861");
        obj.set_input_charset("UTF-8");
        obj.setOut_request_no(packageCode);
        obj.setMerchant_customs_code("3109966673");
        obj.setMerchant_customs_name("\u4e0a\u6d77\u91ce\u6d3e\u7535\u5b50\u5546\u52a1\u6709\u9650\u516c\u53f8");
        obj.setCustoms_place("ZONGSHU");
        obj.setAmount(saleMoney);
        obj.setTrade_no(tradeNo);
        obj.setIs_split("T");
        obj.setSub_out_biz_no(packageCode);
        return obj;
    }
}

