/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.media.enums;

import com.google.common.collect.Lists;
import com.thebeastshop.common.enums.FileTypeEnum;
import java.util.List;

public enum MediaType {
    IMAGE(0, "\u56fe\u7247", Lists.newArrayList((Object[])new FileTypeEnum[]{FileTypeEnum.GIF, FileTypeEnum.JPG, FileTypeEnum.PNG}), "app_image"),
    VIDEO(1, "\u89c6\u9891", Lists.newArrayList((Object[])new FileTypeEnum[]{FileTypeEnum.MP4, FileTypeEnum.AVI}), "app_video"),
    AUDIO(2, "\u97f3\u9891", Lists.newArrayList((Object[])new FileTypeEnum[]{FileTypeEnum.MP3, FileTypeEnum.WAV}), "app_audio");

    private Integer code;
    private String name;
    private List<FileTypeEnum> fileTypeEnums;
    private String extraPath;

    private MediaType(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    private MediaType(Integer code, String name, List<FileTypeEnum> fileTypeEnums) {
        this.code = code;
        this.name = name;
        this.fileTypeEnums = fileTypeEnums;
    }

    private MediaType(Integer code, String name, List<FileTypeEnum> fileTypeEnums, String extraPath) {
        this.code = code;
        this.name = name;
        this.fileTypeEnums = fileTypeEnums;
        this.extraPath = extraPath;
    }

    public Boolean fileTypeContains(FileTypeEnum fileTypeEnum) {
        return this.fileTypeEnums.contains(fileTypeEnum);
    }

    public static MediaType getMediaByFileType(FileTypeEnum fileTypeEnum) {
        for (MediaType mediaType : MediaType.values()) {
            if (!mediaType.fileTypeContains(fileTypeEnum).booleanValue()) continue;
            return mediaType;
        }
        return null;
    }

    public static MediaType getMediaByCode(Integer code) {
        for (MediaType mediaType : MediaType.values()) {
            if (!mediaType.getCode().equals(code)) continue;
            return mediaType;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getExtraPath() {
        return this.extraPath;
    }
}

