package com.thebeastshop.mbgw.sdk.model.order;


import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * 收货地址子模型
 */
public class ReceiverAddressInfo implements Serializable {
    private static final long serialVersionUID = -5635540025385612703L;
    @JSONField(name = "countryCode")
    private String countryCode; // 国家二字码

    @JSONField(name = "district")
    private String district; // 所属区域

    @JSONField(name = "street1")
    private String street1; // 买家地址1

    @JSONField(name = "street2")
    private String street2; // 买家地址2

    @JSONField(name = "city")
    private String city; // 买家城市

    @JSONField(name = "province")
    private String province; // 买家省份

    @JSONField(name = "postCode")
    private String postCode; // 买家邮编

    @JSONField(name = "phone1")
    private String phone1; // 买家电话1

    @JSONField(name = "phone2")
    private String phone2; // 买家电话2

    @JSONField(name = "email")
    private String email; // 买家邮箱

    @JSONField(name = "doorcode")
    private String doorcode; // 买家门牌号

    @JSONField(name = "countryNameEN")
    private String countryNameEN; // 国家英文名称

    @JSONField(name = "countryNameCN")
    private String countryNameCN; // 国家中文名称

    @JSONField(name = "latitude")
    private String latitude; // 纬度

    @JSONField(name = "longitude")
    private String longitude; // 经度

    // Getter/Setter
    public String getCountryCode() { return countryCode; }
    public void setCountryCode(String countryCode) { this.countryCode = countryCode; }
    public String getDistrict() { return district; }
    public void setDistrict(String district) { this.district = district; }
    public String getStreet1() { return street1; }
    public void setStreet1(String street1) { this.street1 = street1; }
    public String getStreet2() { return street2; }
    public void setStreet2(String street2) { this.street2 = street2; }
    public String getCity() { return city; }
    public void setCity(String city) { this.city = city; }
    public String getProvince() { return province; }
    public void setProvince(String province) { this.province = province; }
    public String getPostCode() { return postCode; }
    public void setPostCode(String postCode) { this.postCode = postCode; }
    public String getPhone1() { return phone1; }
    public void setPhone1(String phone1) { this.phone1 = phone1; }
    public String getPhone2() { return phone2; }
    public void setPhone2(String phone2) { this.phone2 = phone2; }
    public String getEmail() { return email; }
    public void setEmail(String email) { this.email = email; }
    public String getDoorcode() { return doorcode; }
    public void setDoorcode(String doorcode) { this.doorcode = doorcode; }
    public String getCountryNameEN() { return countryNameEN; }
    public void setCountryNameEN(String countryNameEN) { this.countryNameEN = countryNameEN; }
    public String getCountryNameCN() { return countryNameCN; }
    public void setCountryNameCN(String countryNameCN) { this.countryNameCN = countryNameCN; }
    public String getLatitude() { return latitude; }
    public void setLatitude(String latitude) { this.latitude = latitude; }
    public String getLongitude() { return longitude; }
    public void setLongitude(String longitude) { this.longitude = longitude; }
}