package com.thebeastshop.mbgw.sdk.client;


import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.mbgw.sdk.request.MbGwRequest;
import com.thebeastshop.mbgw.sdk.response.MbGwResponse;

/**
 * 马帮ERP SDK 客户端接口
 * 定义所有对外提供的API调用方法，是SDK的统一入口
 */
public interface MbGwClient {

    /**
     * 执行API请求（泛型响应）
     * @param request 请求对象（包含接口名和参数）
     * @param dataType 响应数据的类型（如自定义DTO或JSONObject）
     * @return 统一响应对象（包含响应码、消息和业务数据）
     */
    <T> MbGwResponse<T> execute(MbGwRequest request, Class<T> dataType);

    /**
     * 执行API请求（默认返回JSONObject类型）
     * @param request 请求对象
     * @return 统一响应对象（数据类型为JSONObject）
     */
    default MbGwResponse<JSONObject> execute(MbGwRequest request) {
        return execute(request, JSONObject.class);
    }
}