/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.mbgw.sdk.config;

import com.thebeastshop.mbgw.sdk.util.MbGwLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;

public class MbGwSdkConfig {
    private static final Logger log = MbGwLogUtil.getLogger(MbGwSdkConfig.class);
    private static final String DEFAULT_BASE_URL = "https://gwapi.mabangerp.com/api/v2";
    private static final String CONFIG_FILE = "mbgw-sdk.properties";
    private static String apiKey;
    private static String apiToken;
    private static String baseUrl;

    private static void loadFromProperties() {
        try (InputStream is = MbGwSdkConfig.class.getClassLoader().getResourceAsStream(CONFIG_FILE);){
            if (is != null) {
                Properties props = new Properties();
                props.load(is);
                apiKey = props.getProperty("mbgw.apiKey");
                apiToken = props.getProperty("mbgw.apiToken");
                String url = props.getProperty("mbgw.baseUrl");
                if (url != null && !url.isEmpty()) {
                    baseUrl = url;
                }
                log.info("\u4ece\u914d\u7f6e\u6587\u4ef6[{}]\u52a0\u8f7dSDK\u914d\u7f6e\u5b8c\u6210", (Object)CONFIG_FILE);
            } else {
                log.warn("\u672a\u627e\u5230\u914d\u7f6e\u6587\u4ef6[{}]\uff0c\u5c06\u4f7f\u7528\u4ee3\u7801\u521d\u59cb\u5316\u6216\u9ed8\u8ba4\u914d\u7f6e", (Object)CONFIG_FILE);
            }
        }
        catch (IOException e) {
            log.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6[{}]\u5931\u8d25", (Object)CONFIG_FILE, (Object)e);
        }
    }

    public static void init(String apiKey, String apiToken) {
        if (apiKey == null || apiKey.isEmpty() || apiToken == null || apiToken.isEmpty()) {
            log.error("\u521d\u59cb\u5316\u5931\u8d25\uff1aAPI_KEY\u548cAPI_TOKEN\u4e0d\u80fd\u4e3a\u7a7a");
            throw new IllegalArgumentException("API_KEY\u548cAPI_TOKEN\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MbGwSdkConfig.apiKey = apiKey;
        MbGwSdkConfig.apiToken = apiToken;
        log.info("SDK\u521d\u59cb\u5316\u6210\u529f\uff08API_KEY\uff1a{}\uff09", (Object)MbGwSdkConfig.maskApiKey(apiKey));
    }

    public static void init(String apiKey, String apiToken, String baseUrl) {
        MbGwSdkConfig.init(apiKey, apiToken);
        if (baseUrl != null && !baseUrl.isEmpty()) {
            MbGwSdkConfig.baseUrl = baseUrl;
            log.info("SDK\u57fa\u7840URL\u5df2\u8bbe\u7f6e\u4e3a\uff1a{}", (Object)baseUrl);
        }
    }

    private static String maskApiKey(String apiKey) {
        if (apiKey.length() <= 8) {
            return "******";
        }
        return apiKey.substring(0, 4) + "******" + apiKey.substring(apiKey.length() - 4);
    }

    public static String getApiKey() {
        MbGwSdkConfig.checkInit();
        return apiKey;
    }

    public static String getApiToken() {
        MbGwSdkConfig.checkInit();
        return apiToken;
    }

    public static String getBaseUrl() {
        MbGwSdkConfig.checkInit();
        return baseUrl;
    }

    private static void checkInit() {
        if (apiKey == null || apiToken == null) {
            log.error("SDK\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528MbGwSdkConfig.init()");
            throw new IllegalStateException("SDK\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528MbGwSdkConfig.init()");
        }
    }

    static {
        baseUrl = DEFAULT_BASE_URL;
        MbGwSdkConfig.loadFromProperties();
    }
}

