/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.mbgw.sdk.request;

import com.thebeastshop.mbgw.sdk.request.MbGwRequest;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OrderListRequest
extends MbGwRequest {
    public OrderListRequest() {
        super("order-get-order-list-new");
    }

    public OrderListRequest setPage(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("\u9875\u7801\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        this.addParam("cursor", page);
        return this;
    }

    public OrderListRequest setPageSize(int pageSize) {
        if (pageSize < 1 || pageSize > 1000) {
            throw new IllegalArgumentException("\u6bcf\u9875\u6761\u6570\u5fc5\u987b\u57281-1000\u4e4b\u95f4");
        }
        this.addParam("maxRows", pageSize);
        return this;
    }

    public OrderListRequest setUpdateTimeStart(Date startTime) {
        this.addParam("updateTimeStart", this.formatDate(startTime));
        return this;
    }

    public OrderListRequest setUpdateTimeEnd(Date endTime) {
        this.addParam("updateTimeEnd", this.formatDate(endTime));
        return this;
    }

    public OrderListRequest setOrderStatus(String status) {
        this.addParam("status ", status);
        return this;
    }

    public OrderListRequest setCanSend(String canSend) {
        this.addParam("canSend ", canSend);
        return this;
    }

    public OrderListRequest setOrderSource(String source) {
        this.addParam("order_source", source);
        return this;
    }

    private String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }
}

