/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.mbgw.sdk.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.mbgw.sdk.util.MbGwLogUtil;
import java.io.Serializable;
import org.slf4j.Logger;

public class MbGwResponse<T>
implements Serializable {
    private static final Logger log = MbGwLogUtil.getLogger(MbGwResponse.class);
    private static final long serialVersionUID = 1L;
    protected int code;
    protected String message;
    protected T data;
    protected String rawResponse;

    protected MbGwResponse() {
    }

    public static <T> MbGwResponse<T> parse(String json, Class<T> dataType) {
        MbGwResponse<T> response = new MbGwResponse<T>();
        response.rawResponse = json;
        try {
            JSONObject jsonObject = JSON.parseObject((String)json);
            response.code = jsonObject.getIntValue("code");
            response.message = jsonObject.getString("message");
            response.data = dataType != null ? jsonObject.getObject("data", dataType) : jsonObject.get((Object)"data");
        }
        catch (Exception e) {
            log.error("\u54cd\u5e94\u89e3\u6790\u5931\u8d25\uff08\u539f\u59cb\u54cd\u5e94\uff1a{}\uff09", (Object)json, (Object)e);
            throw new RuntimeException("API\u54cd\u5e94\u683c\u5f0f\u9519\u8bef\uff1a" + e.getMessage(), e);
        }
        return response;
    }

    public static <R extends MbGwResponse<D>, D> R parse(String json, Class<R> responseClass, Class<D> dataClass) {
        try {
            MbGwResponse response = (MbGwResponse)responseClass.newInstance();
            response.rawResponse = json;
            JSONObject jsonObj = JSON.parseObject((String)json);
            response.code = jsonObj.getIntValue("code");
            response.message = jsonObj.getString("message");
            if (jsonObj.containsKey((Object)"data") && !jsonObj.get((Object)"data").equals(null)) {
                response.data = JSON.toJavaObject((JSON)jsonObj.getJSONObject("data"), dataClass);
            }
            return (R)response;
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790\u54cd\u5e94\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public boolean isSuccess() {
        return this.code == 200;
    }

    public String toString() {
        return "MbGwResponse{code=" + this.code + ", message='" + this.message + '\'' + ", data=" + (this.data != null ? this.data.toString() : "null") + '}';
    }
}

