/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.sentinel.limit;

import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallback;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcResult;
import com.thebeastshop.kit.sentinel.limit.LimitFallbackInvocation;
import com.thebeastshop.kit.sentinel.limit.LimitFallbackInvoker;
import com.thebeastshop.kit.sentinel.limit.LimitManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeastDubboFallback
implements DubboFallback {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Result handle(Invoker<?> invoker, Invocation invocation, BlockException e) {
        this.log.warn("--- [sentinel] [handle fallback] fallback method:" + invocation.getMethodName());
        Class interfaceClass = invoker.getInterface();
        String methodName = invocation.getMethodName();
        LimitFallbackInvoker fallbackInvoker = LimitManager.getFallbackBean(interfaceClass);
        if (fallbackInvoker != null) {
            LimitFallbackInvocation fallbackInvocation = fallbackInvoker.findFallbackInvocation(methodName, invocation.getParameterTypes());
            if (fallbackInvocation == null) {
                return new RpcResult((Throwable)e);
            }
            if (fallbackInvocation.isRollback()) {
                return invoker.invoke(invocation);
            }
            try {
                fallbackInvocation.invoke(invocation.getArguments());
            }
            finally {
                return new RpcResult((Throwable)e);
            }
        }
    }
}

