package com.thebeastshop.kit.sentinel.limit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-11-20 18:06
 */
public class LimitManager {

    private final static Logger log = LoggerFactory.getLogger(LimitManager.class);

    private final static Map<String, LimitFallbackInvoker> fallbackMap = new HashMap<>();

    public static void registerFallback(Class interfaceClass, Object bean) {
        synchronized (fallbackMap) {
            log.info("[SENTINEL] 注册FALLBACK -> 对应接口: " + interfaceClass.getName() +
                    ", Fallback Class: " + bean.getClass().getName());
            fallbackMap.put(interfaceClass.getName(), new LimitFallbackInvoker(bean));
        }
    }

    public static LimitFallbackInvoker getFallbackBean(String className) {
        return fallbackMap.get(className);
    }

    public static LimitFallbackInvoker getFallbackBean(Class interfaceClass) {
        return getFallbackBean(interfaceClass.getName());
    }


}
