package com.thebeastshop.kit.sentinel.limit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-11-21 14:29
 */
public class LimitFallbackInvoker {
    private final static Logger log = LoggerFactory.getLogger(LimitFallbackInvoker.class);
    private final static String ROLLBACK_METHOD_PREFIX = "rollback";
    private Map<String, LimitFallbackInvocation> fallbackInvocations = new HashMap<>();


    public LimitFallbackInvoker(Object bean) {
        initMethods(bean, bean.getClass());
    }


    public LimitFallbackInvocation findFallbackInvocation(String name, Class[] paramTypes) {
        String key = methodKey(name, paramTypes);
        return fallbackInvocations.get(key);
    }

    private Method[] getDeclaredMethods(Class clazz) {
        return clazz.getDeclaredMethods();
    }

    private String methodKey(String name, Class[] paramTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(name).append('(');
        int len = paramTypes.length;
        for (int i = 0; i < len; i++) {
            Class pType = paramTypes[i];
            builder.append(pType.getName());
            if (i < len - 1) {
                builder.append(',');
            }
        }
        builder.append(')');
        return builder.toString();
    }

    public void initMethods(Object bean, Class clazz) {
        for(Class searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods = searchType.isInterface() ? searchType.getMethods() : getDeclaredMethods(searchType);
            Method[] marr = methods;
            int len = methods.length;

            for(int i = 0; i < len; ++i) {
                Method method = marr[i];
                String name = method.getName();
                Class[] paramTypes =  method.getParameterTypes();
                String key = methodKey(name, paramTypes);
                if (name.startsWith(ROLLBACK_METHOD_PREFIX)) {
                    LimitFallbackInvocation invocation = new LimitFallbackInvocation(null, null);
                    invocation.setRollback(true);
                    log.info("[SENTINEL] --- 映射不做降级的Rollback方法: " + key);
                    fallbackInvocations.put(key, invocation);
                    continue;
                }
                Object ann = null;
                try {
                    ann = method.getAnnotation(LimitFallbackEnable.class);
                } catch (Throwable th) {
                }
                if (ann == null) continue;
                log.info("[SENTINEL] --- 映射Fallback方法: " + key);
                fallbackInvocations.put(key, new LimitFallbackInvocation(bean, method));
            }
        }

    }

}
