package com.thebeastshop.kit.sentinel.limit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-11-21 14:57
 */
public class LimitFallbackInvocation {
    private final Object bean;
    private final Method method;

    private boolean isRollback = false;

    public LimitFallbackInvocation(Object bean, Method method) {
        this.bean = bean;
        this.method = method;
    }

    public Method getMethod() {
        return method;
    }

    public boolean isRollback() {
        return isRollback;
    }

    public void setRollback(boolean rollback) {
        isRollback = rollback;
    }

    public Object invoke(Object[] args) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException();
        }
        return method.invoke(bean, args);
    }
}
