package com.thebeastshop.kit.sentinel.limit;

import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallbackRegistry;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.datasource.apollo.ApolloDataSource;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.thebeastshop.kit.prop.PropConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Properties;

public class ApploDatasourceInitFunc implements InitFunc {

    private final static Logger logger = LoggerFactory.getLogger(ApploDatasourceInitFunc.class);

    private final static String SENTINEL_NAMESPACE = "ARC.sentinel";

    private final static String SENTINEL_RULEKEY_FLOW_RULE = "sentinel.flow.rules";

    private final static String SENTINEL_RULEKEY_DEGRADE_RULE = "sentinel.degrade.rules";

    private final static String SENTINEL_RULEKEY_PARAMFLOW_RULE = "sentinel.paramflow.rules";

    @Override
    public void init() {

        try{
            Properties properties = System.getProperties();
            String env = PropConstants.getEnv(properties);
            logger.info(" [SENTINEL] init Sentinel-Apollo! ENV: " + env);

            if (PropConstants.ENV_LOCAL.equals(env)) {
                // 如果是LOCAL环境，不初始化SENTINEL
                return;
            }
            String metaName = env + "_meta";
            String metaUrl = PropConstants.getProperties(metaName);
            logger.info(" [SENTINEL] init Sentinel-Apollo! META URL: " + metaUrl);
            if (StringUtil.isNotEmpty(metaUrl)) {
                System.setProperty("apollo.meta", metaUrl);
            }

            DubboFallbackRegistry.setProviderFallback(new BeastDubboFallback());

            final ReadableDataSource<String, List<FlowRule>> flowRuleDataSource =
                    new ApolloDataSource<>(SENTINEL_NAMESPACE,
                            SENTINEL_RULEKEY_FLOW_RULE,
                            "[]",
                            new Converter<String, List<FlowRule>>() {
                                @Override
                                public List<FlowRule> convert(String s) {
                                    logger.info("[SENTINEL] Update Flow Rule: " + s);
                                    return JSON.parseObject(s, new TypeReference<List<FlowRule>>() {});
                                }
                            });
            FlowRuleManager.register2Property(flowRuleDataSource.getProperty());

            ReadableDataSource<String, List<DegradeRule>> degradeRuleDataSource =
                    new ApolloDataSource<>(SENTINEL_NAMESPACE,
                            SENTINEL_RULEKEY_DEGRADE_RULE,
                            "[]",
                            new Converter<String, List<DegradeRule>>() {
                                @Override
                                public List<DegradeRule> convert(String s) {
                                    logger.info("[SENTINEL] Update Degrade Rule: " + s);
                                    return JSON.parseObject(s, new TypeReference<List<DegradeRule>>() {});
                                }
                            });
            DegradeRuleManager.register2Property(degradeRuleDataSource.getProperty());

            try {
                Class.forName("com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager");
            } catch (ClassNotFoundException e) {
                return;
            }

            ReadableDataSource<String, List<ParamFlowRule>> paramFlowRuleDataSource =
                    new ApolloDataSource<>(SENTINEL_NAMESPACE,
                            SENTINEL_RULEKEY_PARAMFLOW_RULE,
                            "[]",
                            new Converter<String, List<ParamFlowRule>>() {
                                @Override
                                public List<ParamFlowRule> convert(String s) {
                                    logger.info("[SENTINEL] Update Param Flow Rule: " + s);
                                    return JSON.parseObject(s, new TypeReference<List<ParamFlowRule>>() {});
                                }
                            });
            ParamFlowRuleManager.register2Property(paramFlowRuleDataSource.getProperty());
        }catch(Throwable t){
            logger.error(" [SENTINEL]初始化apollo数据源异常",t);
        }
    }
}
