package com.thebeastshop.common.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExcelRowTemplate implements Serializable {

    public ExcelRowTemplate() {}
    public ExcelRowTemplate(int rowIndex) {
        this.rowNum = rowIndex;
    }
    public ExcelRowTemplate(int rowIndex, List<String> lines) {
        this.rowNum = rowIndex;
        cells = new ArrayList<ExcelRowCellTemplate>();
        buildCells(lines);
    }

    private void buildCells(List<String> lines) {
      if (lines == null || lines.size() == 0) {
          return;
      }
      int lineSize = lines.size();
      for (int i = 0; i < lineSize; i ++) {
        String cellValue = lines.get(i);
        cells.add(new ExcelRowCellTemplate(rowNum, i, cellValue));
      }
    }
    private int rowNum;
    //是否插入一行
    private boolean insertRow = false;
    //是否自动行高
    private boolean isAutoRowHeight = false;
    private List<ExcelRowCellTemplate> cells;

    public List<ExcelRowCellTemplate> getCells() {
        return cells;
    }

    public void setCells(List<ExcelRowCellTemplate> cells) {
        this.cells = cells;
    }

    public int getRowNum() {
        return rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public boolean isInsertRow() {
        return insertRow;
    }

    public void setInsertRow(boolean insertRow) {
        this.insertRow = insertRow;
    }

    public boolean isAutoRowHeight() {
        return isAutoRowHeight;
    }

    public void setAutoRowHeight(boolean autoRowHeight) {
        isAutoRowHeight = autoRowHeight;
    }
}
