package com.thebeastshop.common.utils;

import org.springframework.core.convert.converter.Converter;

public class ChineseBooleanConvert implements Converter<String, Boolean> {

	@Override
	public Boolean convert(String source) {
		if(source!=null){
			if(source.trim().equals("是")) {
				return true;
			} else if(source.trim().equals("否")) {
				return false;
			} else {
				throw new IllegalArgumentException(source+" can not be converted to boolean!");
			}
		}
		return null;
	}

}
