package com.thebeastshop.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * <p>Title: thebeastshop</p>
 * <p>Copyright: Copyright (c) 2016</p>
 * @author Bryan Zhang
 * @date 2017-2-13
 * @description
 */
public class PriceUtil {
	/**
	 * 保留到分，厘位四舍五入
	 *
	 * @return
	 */
	public static BigDecimal keepToCent(final BigDecimal d) {
		return d.setScale(2, RoundingMode.HALF_UP);
	}

	/**
	 * 取得相应的折扣(天猫，京东渠道)
	 * @param price
	 * @param
	 * @return BigDecimal
	 */
	public static BigDecimal getDiscountPrice(BigDecimal price, float discount) {

		BigDecimal discountPrice=price;
		if (discountPrice == null) {
			return new BigDecimal(0);
		}
		// vip
		discountPrice= price.multiply(new BigDecimal(discount));
		discountPrice=discountPrice.setScale(2, RoundingMode.HALF_UP);
		return discountPrice;
	}
}
