package com.thebeastshop.common.utils;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class ExcelCellStyle {

    public ExcelCellStyle() {};
    public ExcelCellStyle(BorderStyle borderLeft, Short leftBorderColor, Short fontSize, String fontName) {
        this.borderLeft = borderLeft;
        this.leftBorderColor = leftBorderColor;
        this.fontSize = fontSize;
        this.fontName = fontName;
    }
    private BorderStyle borderLeft;
    private BorderStyle borderRight;
    private BorderStyle borderTop;
    private BorderStyle borderBottom;
    private BorderStyle border;
    private Short leftBorderColor;
    private Short fontSize = 9;
    private String fontName = "宋体";
    private HorizontalAlignment alignment;
    //背景色
    private Short color;

    private Short fillForegroundColor;

    private FillPatternType fillPattern;

    //单元格垂直对齐方式
    private Short verticalAlignment = 0x01;
    //是否自动换行
    private boolean wrapText = false;


   public BorderStyle getBorderLeft() {
        return borderLeft;
    }

    public void setBorderLeft(BorderStyle borderLeft) {
        this.borderLeft = borderLeft;
    }

    public Short getLeftBorderColor() {
        return leftBorderColor;
    }

    public void setLeftBorderColor(Short leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
    }

    public Short getFontSize() {
        return fontSize;
    }

    public void setFontSize(Short fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontName() {
        return fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public BorderStyle getBorderRight() {
        return borderRight;
    }

    public void setBorderRight(BorderStyle borderRight) {
        this.borderRight = borderRight;
    }

    public BorderStyle getBorderTop() {
        return borderTop;
    }

    public void setBorderTop(BorderStyle borderTop) {
        this.borderTop = borderTop;
    }

    public BorderStyle getBorderBottom() {
        return borderBottom;
    }

    public void setBorderBottom(BorderStyle borderBottom) {
        this.borderBottom = borderBottom;
    }

    public BorderStyle getBorder() {
        return border;
    }

    public void setBorder(BorderStyle border) {
        this.border = border;
    }

    public HorizontalAlignment getAlignment() {
        return alignment;
    }

    public void setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
    }

    public Short getColor() {
        return color;
    }

    public void setColor(Short color) {
        this.color = color;
    }

    public Short getFillForegroundColor() {
        return fillForegroundColor;
    }

    public void setFillForegroundColor(Short fillForegroundColor) {
        this.fillForegroundColor = fillForegroundColor;
    }

    public FillPatternType getFillPattern() {
        return fillPattern;
    }

    public void setFillPattern(FillPatternType fillPattern) {
        this.fillPattern = fillPattern;
    }

    public boolean isWrapText() {
        return wrapText;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
    }

    public Short getVerticalAlignment() {
        return verticalAlignment;
    }

    public void setVerticalAlignment(Short verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }
}
