package com.thebeastshop.common.utils;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 对象变更日志
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ObjectChangeLog {
    String name() default  "";
    String value() default "";
    String fieldType() default "";
    String className() default "";
    String getMethod() default "";
    String dateTimeFormat() default "yyyy-MM-dd HH:mm:ss";
    boolean required() default true;
    boolean needVerifyChanged() default true;
    boolean auditRequired() default false;
    boolean ignoreLog() default false;
    int logType() default 1;

}
