package com.thebeastshop.common.ecp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import sun.misc.BASE64Decoder;

import java.util.*;

public class RemoteData {
    private HashMap<String,String> SystemList;
    private HashMap<String,String> ApplicationList;
    private String appKey="";
    private String secretKey="";
    private String sessionKey="";
    private String functionName="";
    private String timeStamp="";
    private String async="";
    private String topic="";
    private String furl="";
    private String HttpResponse ="";
    private String LastError="";


    public RemoteData()
    {
        SystemList=new HashMap<String,String>();
        ApplicationList=new HashMap<String,String>();
    }
    private String getTimeStamp(){
        long unixTime = System.currentTimeMillis() / 1000L;
        timeStamp=String.valueOf(unixTime);
        return timeStamp;
    }
    public void SetAppKey(String _AppKey){
        appKey=_AppKey;
    }
    public void SetSecretKey(String _SecretKey){
        secretKey=_SecretKey;
    }
    public void SetSessionKey(String _SessionKey){
        sessionKey=_SessionKey;
    }
    public void SetTopic(String _Topic){
        topic=_Topic;
    }
    public void SetUrl(String Url){furl=Url;}
    private String MD5(String md5) {
        try {
            java.security.MessageDigest md = java.security.MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString((array[i] & 0xFF) | 0x100).substring(1,3));
            }
            return sb.toString().toUpperCase();
        } catch (java.security.NoSuchAlgorithmException e) {
        }
        return null;
    }
    private void MergeList(HashMap List1,HashMap List2,HashMap List3)
    {
        List3.clear();
        Set MapSet=List1.entrySet();
        Iterator mapIterator = MapSet.iterator();
        while (mapIterator.hasNext())
        {
            Map.Entry mapEntry = (Map.Entry) mapIterator.next();
            List3.put((String)mapEntry.getKey(),(String)mapEntry.getValue());
        }
        Set MapSet2=List2.entrySet();
        Iterator mapIterator2 = MapSet2.iterator();
        while (mapIterator2.hasNext())
        {
            Map.Entry mapEntry2 = (Map.Entry) mapIterator2.next();
            List3.put((String)mapEntry2.getKey(),(String)mapEntry2.getValue());
        }

    }
    private String CalcMd5() {
        initSystemList();
        if (SystemList.containsKey("_Sign")) {
            SystemList.remove("_Sign");
        }
        HashMap<String,String> List=new HashMap<String,String>();
        MergeList(SystemList,ApplicationList,List);
        TreeMap<String,String> tm=new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        tm.putAll(List);
        StringBuilder sb=new StringBuilder();
        Set MapSet2=tm.entrySet();
        Iterator mapIterator2 = MapSet2.iterator();
        while (mapIterator2.hasNext())
        {
            Map.Entry mapEntry2 = (Map.Entry) mapIterator2.next();
            sb.append((String)mapEntry2.getKey());
            sb.append((String)mapEntry2.getValue());
        }
        String sbStr=sb.toString();
        String resultstr = secretKey + sbStr + secretKey;
        return MD5(resultstr);
    }
    private void initSystemList(){
        SystemList.clear();
        SystemList.put("_Topic",topic);
        SystemList.put("_SessionKey",sessionKey);
        SystemList.put("_AppKey",appKey);
        SystemList.put("_Async","False");
        SystemList.put("_FunctionName",functionName);
        SystemList.put("_TimeStamp",getTimeStamp());
    }

    private String GetPostContent(HashMap List1,HashMap List2)
    {
        try{
            JSONObject jsobj=JSON.parseObject("{}");
            Set MapSet=List1.entrySet();
            Iterator mapIterator = MapSet.iterator();
            while (mapIterator.hasNext())
            {
                Map.Entry mapEntry = (Map.Entry) mapIterator.next();
                jsobj.put((String)mapEntry.getKey(),(String)mapEntry.getValue());
            }
            JSONArray jr=JSONArray.parseArray("[]");

            Set MapSet2=List2.entrySet();
            Iterator mapIterator2 = MapSet2.iterator();
            while (mapIterator2.hasNext())
            {
                JSONObject jsp=JSONObject.parseObject("{}");
                Map.Entry mapEntry2 = (Map.Entry) mapIterator2.next();
                jsp.put((String)mapEntry2.getKey(),(String)mapEntry2.getValue());
                jr.add(jsp);
            }
            jsobj.put("Params",jr);
            String fPostJsonData=jsobj.toString();
            return fPostJsonData;
            //System.out.println(fPostJsonData);
        } catch (Exception e) {
            String strError= e.toString();
            return "";
            //System.out.println(strError);
        }
    }
    public String GetRemotePostContent()
    {
        String md5String=CalcMd5();
        SystemList.put("_Sign", md5String);
        return GetPostContent(SystemList, ApplicationList);
    }
    public String GetUrl(){
        return furl+"?format=json";
    }

    public String GetResponse(){
        return HttpResponse;
    }
    public String GetLastError(){
        return LastError;
    }

    public  int unBase64(String Str){
        JSONObject jsobj=JSONObject.parseObject(Str);
        int Status=jsobj.getInteger("Status");
        String msg=jsobj.getString("Msg");
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] decodedBytes = decoder.decodeBuffer(msg);
            msg = new String(decodedBytes, "UTF-8");
            if (Status == 0) {
                HttpResponse = msg;
            } else {
                LastError = msg;
            }
            return Status;
        }
        catch(Exception e) {
            LastError=e.toString();
            return -1;
        }
    }

    public void AddMethod(String FunctionName) {
        functionName=FunctionName;
    }

    public void AddParam(String Name,String Value){
        if (ApplicationList.containsKey(Name)==false) {
            ApplicationList.put(Name, Value);
        }else{
            ApplicationList.remove(Name);
            ApplicationList.put(Name,Value);
        }
    }


}
