/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.rocketmq;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.kit.rocketmq.BeforeSend;
import com.thebeastshop.kit.rocketmq.OnException;
import com.thebeastshop.kit.rocketmq.OnSend;
import com.thebeastshop.kit.rocketmq.RDelay;
import com.thebeastshop.kit.rocketmq.RocketMQ;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.util.Strings;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;

public class RMessage<T> {
    public static final String KEY_MSG_ID = "MSG_ID";
    private final String topic;
    private int flag;
    private String keys;
    private String tags;
    private boolean waitStoreMsgOK = true;
    private String buyerId;
    private String instanceId;
    private String msgId;
    private RDelay delay;
    private long timeout;
    private T body;
    private BeforeSend beforeSend;
    private OnSend onSend;
    private OnException onException;
    private Boolean logEnabled = true;
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();

    public static <T> RMessage<T> topic(String topic) {
        return new RMessage<T>(topic);
    }

    public RMessage(String topic) {
        this.topic = topic;
    }

    public String topic() {
        return this.topic;
    }

    public int flag() {
        return this.flag;
    }

    public RMessage<T> flag(int flag) {
        this.flag = flag;
        return this;
    }

    public String keys() {
        return this.keys;
    }

    public RMessage<T> keys(String keys) {
        this.keys = keys;
        return this;
    }

    public String tags() {
        return this.tags;
    }

    public RMessage<T> tags(String tags) {
        this.tags = tags;
        return this;
    }

    public boolean isWaitStoreMsgOK() {
        return this.waitStoreMsgOK;
    }

    public RMessage<T> waitStoreMsgOK(boolean waitStoreMsgOK) {
        this.waitStoreMsgOK = waitStoreMsgOK;
        return this;
    }

    public String buyerId() {
        return this.buyerId;
    }

    public RMessage<T> buyerId(String buyerId) {
        this.buyerId = buyerId;
        return this;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public RMessage<T> instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String msgId() {
        return this.msgId;
    }

    RMessage<T> msgId(String transactionId) {
        this.msgId = transactionId;
        return this;
    }

    public RDelay delay() {
        return this.delay;
    }

    public RMessage<T> delay(RDelay delay) {
        this.delay = delay;
        return this;
    }

    public long timeout() {
        return this.timeout;
    }

    public RMessage<T> timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public T body() {
        return this.body;
    }

    public RMessage<T> body(T body) {
        this.body = body;
        return this;
    }

    public BeforeSend beforeSend() {
        return this.beforeSend;
    }

    public RMessage<T> beforeSend(BeforeSend beforeSend) {
        this.beforeSend = beforeSend;
        return this;
    }

    public OnSend onSend() {
        return this.onSend;
    }

    public RMessage<T> onSend(OnSend onSend) {
        this.onSend = onSend;
        return this;
    }

    public OnException onException() {
        return this.onException;
    }

    public RMessage<T> onException(OnException onException) {
        this.onException = onException;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public RMessage<T> setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public boolean logEnabled() {
        return this.logEnabled;
    }

    public RMessage<T> logEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public byte[] bodyBytes() {
        if (this.body == null) {
            return new byte[0];
        }
        if (this.body instanceof byte[]) {
            return (byte[])this.body;
        }
        if (this.body instanceof CharSequence) {
            return this.body.toString().getBytes(StandardCharsets.UTF_8);
        }
        String json = JSON.toJSONString(this.body);
        return json.getBytes(StandardCharsets.UTF_8);
    }

    public Message toRocketMessage() {
        Message message = new Message(this.topic, this.bodyBytes());
        message.setWaitStoreMsgOK(this.waitStoreMsgOK);
        message.getProperties().putAll(this.properties);
        if (Strings.isNotEmpty((CharSequence)this.msgId)) {
            message.putUserProperty(KEY_MSG_ID, this.msgId);
        }
        if (Strings.isNotEmpty((CharSequence)this.keys)) {
            message.setKeys(this.keys);
        }
        if (Strings.isNotEmpty((CharSequence)this.tags)) {
            message.setTags(this.tags);
        }
        if (Strings.isNotEmpty((CharSequence)this.buyerId)) {
            message.setBuyerId(this.buyerId);
        }
        if (Strings.isNotEmpty((CharSequence)this.instanceId)) {
            message.setInstanceId(this.instanceId);
        }
        if (this.delay != null) {
            message.setDelayTimeLevel(this.delay.getTimeLevel());
        }
        return message;
    }

    public SendResult syncSend() {
        return RocketMQ.client().syncSend(this);
    }

    public void asyncSend() {
        RocketMQ.client().asyncSend(this);
    }

    public String toString() {
        return "RMessage {topic: '" + this.topic + '\'' + ", flag: " + this.flag + ", body: " + Arrays.toString(this.bodyBytes()) + ", transactionId: '" + this.msgId + '\'' + '}';
    }
}

