/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.rocketmq;

import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.kit.id.UniqueIdGenerator;
import com.thebeastshop.kit.rocketmq.OnException;
import com.thebeastshop.kit.rocketmq.OnSend;
import com.thebeastshop.kit.rocketmq.RDelay;
import com.thebeastshop.kit.rocketmq.RMessage;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RocketMQTemplate rocketMQTemplate;
    private static RClient rClient;
    private long defaultSendMessageTimeout = 3000L;

    public static RClient getClient(RocketMQTemplate rocketMQTemplate) {
        if (rClient == null) {
            rClient = new RClient(rocketMQTemplate);
        }
        return rClient;
    }

    public static RClient getClient() {
        return rClient;
    }

    public RClient(RocketMQTemplate rocketMQTemplate) {
        this.rocketMQTemplate = rocketMQTemplate;
    }

    public long getDefaultSendMessageTimeout() {
        return this.defaultSendMessageTimeout;
    }

    public void setDefaultSendMessageTimeout(long defaultSendMessageTimeout) {
        this.defaultSendMessageTimeout = defaultSendMessageTimeout;
    }

    public RocketMQTemplate getRocketMQTemplate() {
        return this.rocketMQTemplate;
    }

    public DefaultMQProducer getProducer() {
        return this.rocketMQTemplate.getProducer();
    }

    public void processException(Exception ex, OnException onException) {
        if (onException == null) {
            throw new RuntimeException(ex);
        }
        onException.onException(ex);
    }

    public SendResult syncSend(Message message, long timeout) {
        return this.syncSend(message, null, null, timeout);
    }

    private SendResult syncSend(Message message, OnSend onSend, OnException onException, long timeout) {
        try {
            SendResult sendResult = this.getProducer().send(message, timeout > 0L ? timeout : this.defaultSendMessageTimeout);
            if (onSend != null) {
                onSend.onSend(sendResult);
            }
            return sendResult;
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            this.processException((Exception)e, onException);
            return null;
        }
    }

    private void asyncSend(Message message, SendCallback sendCallback, long timeout) {
        try {
            this.getProducer().send(message, sendCallback, timeout > 0L ? timeout : this.defaultSendMessageTimeout);
        }
        catch (InterruptedException | MQClientException | RemotingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> SendResult syncSend(RMessage<T> message) {
        Validation.paramNotNull(message, (String)"message \u4e3a\u7a7a");
        this.beforeSend(message);
        Message rocketMessage = message.toRocketMessage();
        this.logMessage(message, rocketMessage);
        return this.syncSend(rocketMessage, message.onSend(), message.onException(), message.timeout());
    }

    public <T> void asyncSend(final RMessage<T> message) {
        Validation.paramNotNull(message, (String)"message \u4e3a\u7a7a");
        this.beforeSend(message);
        Message rocketMessage = message.toRocketMessage();
        this.logMessage(message, rocketMessage);
        this.asyncSend(rocketMessage, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                OnSend onSend = message.onSend();
                if (onSend != null) {
                    onSend.onSend(sendResult);
                }
            }

            public void onException(Throwable throwable) {
                OnException onException = message.onException();
                if (onException != null) {
                    onException.onException(throwable);
                }
            }
        }, message.timeout());
    }

    private <T> void beforeSend(RMessage<T> message) {
        long id = UniqueIdGenerator.generateId();
        message.msgId(id + "");
        if (message.beforeSend() != null) {
            message.beforeSend().beforeSend(message);
        }
    }

    private <T> void logMessage(RMessage<T> message, Message rocketMessage) {
        if (message.logEnabled()) {
            String delay;
            StringBuilder content = new StringBuilder("[RocketMQ \u751f\u4ea7\u8005] \u53d1\u9001\u6d88\u606f(").append("id = ").append(message.msgId()).append(", topic = ").append(rocketMessage.getTopic());
            if (StringUtils.isNotEmpty((CharSequence)message.tags())) {
                content.append(", tags = ").append(message.tags());
            }
            if (StringUtils.isNotEmpty((CharSequence)(delay = RDelay.timeLevelToString(rocketMessage.getDelayTimeLevel())))) {
                content.append(", delay = ").append(delay);
            }
            content.append("):\n\t");
            content.append(new String(rocketMessage.getBody(), StandardCharsets.UTF_8));
            this.log.info(content.toString());
        }
    }
}

