package com.thebeastshop.kit.rocketmq;

import com.alibaba.fastjson.JSON;
import org.apache.logging.log4j.util.Strings;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RMessage<T> {

    public final static String KEY_MSG_ID = "MSG_ID";

    private final String topic;

    private int flag;

    private String keys;

    private String tags;

    private boolean waitStoreMsgOK = true;

    private String buyerId;

    private String instanceId;

    private String msgId;

    private RDelay delay;

    private long timeout;

    private T body;

    private BeforeSend beforeSend;

    private OnSend onSend;

    private OnException onException;

    private Boolean logEnabled = true;

    private Map<String, String> properties = new ConcurrentHashMap<>();

    public static <T> RMessage<T> topic(String topic) {
        return new RMessage<>(topic);
    }

    public RMessage(String topic) {
        this.topic = topic;
    }

    public String topic() {
        return topic;
    }

    public int flag() {
        return flag;
    }

    public RMessage<T> flag(int flag) {
        this.flag = flag;
        return this;
    }

    public String keys() {
        return keys;
    }

    public RMessage<T> keys(String keys) {
        this.keys = keys;
        return this;
    }

    public String tags() {
        return tags;
    }

    public RMessage<T> tags(String tags) {
        this.tags = tags;
        return this;
    }

    public boolean isWaitStoreMsgOK() {
        return waitStoreMsgOK;
    }

    public RMessage<T> waitStoreMsgOK(boolean waitStoreMsgOK) {
        this.waitStoreMsgOK = waitStoreMsgOK;
        return this;
    }

    public String buyerId() {
        return buyerId;
    }

    public RMessage<T> buyerId(String buyerId) {
        this.buyerId = buyerId;
        return this;
    }

    public String instanceId() {
        return instanceId;
    }

    public RMessage<T> instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String msgId() {
        return msgId;
    }

    RMessage<T> msgId(String transactionId) {
        this.msgId = transactionId;
        return this;
    }

    public RDelay delay() {
        return delay;
    }

    public RMessage<T> delay(RDelay delay) {
        this.delay = delay;
        return this;
    }

    public long timeout() {
        return timeout;
    }

    public RMessage<T> timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public T body() {
        return body;
    }

    public RMessage<T> body(T body) {
        this.body = body;
        return this;
    }

    public BeforeSend beforeSend() {
        return beforeSend;
    }

    public RMessage<T> beforeSend(BeforeSend beforeSend) {
        this.beforeSend = beforeSend;
        return this;
    }

    public OnSend onSend() {
        return onSend;
    }

    public RMessage<T> onSend(OnSend onSend) {
        this.onSend = onSend;
        return this;
    }

    public OnException onException() {
        return onException;
    }

    public RMessage<T> onException(OnException onException) {
        this.onException = onException;
        return this;
    }

    public Map<String, String> getProperties() {
        return properties;
    }

    public String getProperty(String name) {
        return properties.get(name);
    }

    public RMessage<T> setProperty(String name, String value) {
        properties.put(name, value);
        return this;
    }

    public boolean logEnabled() {
        return logEnabled;
    }

    public RMessage<T> logEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public byte[] bodyBytes() {
        if (body == null) {
            return new byte[0];
        }
        if (body instanceof byte[]) {
            return (byte[]) body;
        }
        if (body instanceof CharSequence) {
            return body.toString().getBytes(StandardCharsets.UTF_8);
        }
        String json = JSON.toJSONString(body);
        return json.getBytes(StandardCharsets.UTF_8);
    }

    public Message toRocketMessage() {
        Message message = new Message(topic, bodyBytes());
        message.setWaitStoreMsgOK(waitStoreMsgOK);
        message.getProperties().putAll(properties);
        if (Strings.isNotEmpty(msgId)) {
            message.putUserProperty(KEY_MSG_ID, msgId);
        }
        if (Strings.isNotEmpty(keys)) {
            message.setKeys(keys);
        }
        if (Strings.isNotEmpty(tags)) {
            message.setTags(tags);
        }
        if (Strings.isNotEmpty(buyerId)) {
            message.setBuyerId(buyerId);
        }
        if (Strings.isNotEmpty(instanceId)) {
            message.setInstanceId(instanceId);
        }
        if (delay != null) {
            message.setDelayTimeLevel(delay.getTimeLevel());
        }
        return message;
    }

    public SendResult syncSend() {
        return RocketMQ.client().syncSend(this);
    }

    public void asyncSend() {
        RocketMQ.client().asyncSend(this);
    }

    @Override
    public String toString() {
        return "RMessage {" +
                "topic: '" + topic + '\'' +
                ", flag: " + flag +
                ", body: " + Arrays.toString(bodyBytes()) +
                ", transactionId: '" + msgId + '\'' +
                '}';
    }

}
