package com.thebeastshop.kit.rocketmq;

import java.util.concurrent.TimeUnit;

/**
 *
 */
public enum RDelay {

    TIME_1_SECONDS(1, 1, TimeUnit.SECONDS),

    TIME_5_SECONDS(2, 5, TimeUnit.SECONDS),

    TIME_10_SECONDS(3, 10, TimeUnit.SECONDS),

    TIME_30_SECONDS(4, 30, TimeUnit.SECONDS),

    TIME_1_MINUTES(5, 1, TimeUnit.MINUTES),

    TIME_2_MINUTES(6, 2, TimeUnit.MINUTES),

    TIME_3_MINUTES(7, 3, TimeUnit.MINUTES),

    TIME_4_MINUTES(8, 4, TimeUnit.MINUTES),

    TIME_5_MINUTES(9, 5, TimeUnit.MINUTES),

    TIME_6_MINUTES(10, 6, TimeUnit.MINUTES),

    TIME_7_MINUTES(11, 7, TimeUnit.MINUTES),

    TIME_8_MINUTES(12, 8, TimeUnit.MINUTES),

    TIME_9_MINUTES(13, 9, TimeUnit.MINUTES),

    TIME_10_MINUTES(14, 10, TimeUnit.MINUTES),

    TIME_20_MINUTES(15, 20, TimeUnit.MINUTES),

    TIME_30_MINUTES(16, 30, TimeUnit.MINUTES),

    TIME_1_HOURS(17, 1, TimeUnit.HOURS),

    TIME_2_HOURS(18, 2, TimeUnit.HOURS),

    ;

    private final int timeLevel;

    private final int duration;

    private final TimeUnit timeUnit;

    RDelay(int timeLevel, int duration, TimeUnit timeUnit) {
        this.timeLevel = timeLevel;
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public int getTimeLevel() {
        return timeLevel;
    }

    public int getDuration() {
        return duration;
    }

    public TimeUnit getTimeUnit() {
        return timeUnit;
    }

    private final static RDelay[] DELAY_CACHE = new RDelay[18];

    public static RDelay getByTimeLevel(int timeLevel) {
        RDelay delay = DELAY_CACHE[timeLevel];
        if (delay == null) {
            RDelay[] values = RDelay.values();
            for (int i = 0; i < values.length; i++) {
                RDelay value = values[i];
                if (value.timeLevel == timeLevel) {
                    DELAY_CACHE[i] = value;
                    return value;
                }
            }
        }
        return delay;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(duration);
        switch (timeUnit) {
            case SECONDS:
                builder.append("秒");
                break;
            case MINUTES:
                builder.append("分钟");
                break;
            case HOURS:
                builder.append("小时");
                break;
        }
        return builder.toString();
    }

    public static String timeLevelToString(int timeLevel) {
        if (timeLevel > 0) {
            RDelay delay = RDelay.getByTimeLevel(timeLevel);
            if (delay != null) {
                return delay.toString();
            }
        }
        return "";
    }
}
