package com.thebeastshop.kit.prop.springboot;


import com.thebeastshop.kit.prop.PropConfig;
import com.thebeastshop.kit.prop.PropPropertiesSource;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

import java.util.Iterator;
import java.util.Map;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2019-03-06 19:04
 */
public class PropContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {

    @Override
    public void initialize(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        this.initializeSystemProperty(environment);
    }

    public static boolean matchLocalPropertySource(PropertySource source) {
        return source.getName().startsWith("applicationConfig:")
                || source.getName().startsWith("Config resource 'class path resource");
    }


    void initializeSystemProperty(ConfigurableEnvironment environment) {
        if (!environment.getPropertySources().contains("PropBootstrapPropertySources")) {
            CompositePropertySource composite = new CompositePropertySource("PropBootstrapPropertySources");
            composite.addPropertySource(new PropPropertiesSource("PropSource"));
            environment.getPropertySources().addFirst(composite);
        }
        PropConfig config = PropConfig.getInstance();
        for (final PropertySource source : environment.getPropertySources()) {
            if (matchLocalPropertySource(source)) {
                if (PropConfig.getEnv().equals(PropConfig.ENV_LOCAL)) {
                    config.mergeLocalConfigSource((Map<?, ?>) source.getSource());
                    config.printAllProperties();
                } else {
                    environment.getPropertySources().remove(source.getName());
                }
                return;
            }
        }

    }


}
