package com.thebeastshop.kit.prop;

import com.thebeastshop.kit.prop.PropConfig;
import com.thebeastshop.kit.prop.PropConstants;
import org.apache.commons.collections.MapUtils;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class PropSpringConstants extends PropConstants {

    @Override
    protected Properties mergeProperties() throws IOException {
        Properties properties = super.mergeProperties();
        PropConfig config = PropConfig.getInstance();
        for (Enumeration<?> enumeration = properties.propertyNames();
             enumeration.hasMoreElements(); ) {
            String name = enumeration.nextElement().toString();
            Object propValue = properties.getProperty(name);
            if (propValue != null) {
                Object configValue = config.getProperty(name);
                if (configValue == null) {
                    config.setProperty(name, propValue);
                }
            }
        }
        config.mergeLocalConfigSource(MapUtils.EMPTY_MAP);
        config.printAllProperties();
        return config.getProps();

    }
}
