/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.prop.springboot;

import com.ctrip.framework.apollo.spring.annotation.SpringValueProcessor;
import com.ctrip.framework.apollo.spring.property.SpringValueDefinitionProcessor;
import com.ctrip.framework.apollo.spring.util.BeanRegistrationUtil;
import com.thebeastshop.kit.prop.PropAnnotationProcessor;
import com.thebeastshop.kit.prop.PropConfig;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class PropConstantsProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware,
PriorityOrdered,
BeanDefinitionRegistryPostProcessor {
    private ConfigurableEnvironment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists((BeanDefinitionRegistry)registry, (String)PropertySourcesPlaceholderConfigurer.class.getName(), PropertySourcesPlaceholderConfigurer.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists((BeanDefinitionRegistry)registry, (String)PropAnnotationProcessor.class.getName(), PropAnnotationProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists((BeanDefinitionRegistry)registry, (String)SpringValueProcessor.class.getName(), SpringValueProcessor.class);
        this.processSpringValueDefinition(registry);
    }

    private boolean matchLocalPropertySource(PropertySource source) {
        return source.getName().startsWith("applicationConfig:") || source.getName().startsWith("Config resource 'class path resource");
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        PropConfig config = PropConfig.getInstance();
        for (PropertySource source : this.environment.getPropertySources()) {
            if (!this.matchLocalPropertySource(source)) continue;
            if (PropConfig.getEnv().equals("local")) {
                config.mergeLocalConfigSource((Map)source.getSource());
                config.printAllProperties();
            } else {
                this.environment.getPropertySources().remove(source.getName());
            }
            return;
        }
    }

    private void processSpringValueDefinition(BeanDefinitionRegistry registry) {
        SpringValueDefinitionProcessor springValueDefinitionProcessor = new SpringValueDefinitionProcessor();
        springValueDefinitionProcessor.postProcessBeanDefinitionRegistry(registry);
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

