/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.prop.annotation;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.kit.prop.PropConstants;
import java.lang.reflect.Field;
import org.springframework.util.ReflectionUtils;

public class DynamicPropAccessor {
    private String propName;
    private Object bean;
    private Field field;
    private Class fieldType;

    public DynamicPropAccessor(String propName, Object bean, Field field) {
        this.propName = propName;
        this.bean = bean;
        this.field = field;
        this.fieldType = field.getType();
    }

    private Object convertFieldValue(String newValue) {
        if (newValue == null) {
            return null;
        }
        if (CharSequence.class.isAssignableFrom(this.fieldType)) {
            return newValue;
        }
        if (Byte.TYPE.isAssignableFrom(this.fieldType) || Byte.class.isAssignableFrom(this.fieldType)) {
            return Byte.parseByte(newValue);
        }
        if (Character.TYPE.isAssignableFrom(this.fieldType)) {
            return Character.valueOf(newValue.charAt(0));
        }
        if (Boolean.TYPE.isAssignableFrom(this.fieldType) || Boolean.class.isAssignableFrom(this.fieldType)) {
            return Boolean.parseBoolean(newValue);
        }
        if (Integer.TYPE.isAssignableFrom(this.fieldType) || Integer.class.isAssignableFrom(this.fieldType)) {
            return Integer.parseInt(newValue);
        }
        if (Short.TYPE.isAssignableFrom(this.fieldType) || Short.class.isAssignableFrom(this.fieldType)) {
            return Short.parseShort(newValue);
        }
        if (Long.TYPE.isAssignableFrom(this.fieldType) || Long.class.isAssignableFrom(this.fieldType)) {
            return Long.parseLong(newValue);
        }
        if (Float.TYPE.isAssignableFrom(this.fieldType) || Float.class.isAssignableFrom(this.fieldType)) {
            return Float.valueOf(Float.parseFloat(newValue));
        }
        if (this.fieldType.isEnum()) {
            return Enum.valueOf(this.fieldType, newValue);
        }
        if (Double.TYPE.isAssignableFrom(this.fieldType) || Double.class.isAssignableFrom(this.fieldType)) {
            return Double.parseDouble(newValue);
        }
        try {
            return JSON.parseObject((String)newValue, (Class)this.fieldType);
        }
        catch (Exception e) {
            return newValue;
        }
    }

    public synchronized void refreshValue() {
        String newValue = PropConstants.getProperties(this.propName);
        Object val = this.convertFieldValue(newValue);
        ReflectionUtils.setField((Field)this.field, (Object)this.bean, (Object)val);
    }
}

