package com.thebeastshop.kit.prop.springboot;

import com.thebeastshop.kit.prop.PropConfig;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

import java.util.Map;

import static com.thebeastshop.kit.prop.springboot.PropContextInitializer.matchLocalPropertySource;

public class PropEnvironmentInitializer implements ApplicationListener<ApplicationEvent> {
    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            ConfigurableEnvironment environment = ((ApplicationEnvironmentPreparedEvent) event).getEnvironment();
            for (final PropertySource source : environment.getPropertySources()) {
                if (matchLocalPropertySource(source)) {
                    if (!PropConfig.getEnv().equals(PropConfig.ENV_LOCAL)) {
                        environment.getPropertySources().remove(source.getName());
                    }
                    return;
                }
            }

        }
    }
}
