/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.prop;

import com.alibaba.fastjson.JSON;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.google.common.collect.Lists;
import com.thebeastshop.kit.prop.ApolloPropChangeEvent;
import com.thebeastshop.kit.prop.PropChange;
import com.thebeastshop.kit.prop.PropChangeCallback;
import com.thebeastshop.kit.prop.PropChangeEvent;
import com.thebeastshop.kit.prop.PropChangeListener;
import com.thebeastshop.kit.prop.PropPatternProcessor;
import com.thebeastshop.kit.prop.ServiceUtil;
import com.thebeastshop.kit.prop.annotation.DynamicPropAccessor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class PropConfig {
    private static final Logger log = LoggerFactory.getLogger(PropConfig.class);
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final AtomicBoolean PRINTED = new AtomicBoolean(false);
    private static final AtomicBoolean MERGED = new AtomicBoolean(false);
    private static final String ENV_KEY = "env";
    private static final String APP_ID = "app.id";
    private static final String APOLLO_CLUSTER = "apollo.cluster";
    private static final String NAMESPACES_KEY = "app.namespaces";
    private static final String NAMESPACE_APPLICATION = "application";
    public static final String ENV_LOCAL = "local";
    public static final String ENV_TEST = "test";
    public static final String ENV_PRE = "pre";
    public static final String ENV_PROD = "prod";
    private static final String APOLLO_FAT = "fat";
    private static final String APOLLO_UAT = "uat";
    private static final String APOLLO_PRO = "pro";
    private static volatile PropConfig propConfig;
    private volatile ConfigurableEnvironment environment;
    private volatile boolean printed = false;
    private Properties props = new Properties();
    private ConfigMeta meta;
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private Map<String, Map<String, Map<String, PropChangeCallback>>> propChangeCallbackMap = new HashMap<String, Map<String, Map<String, PropChangeCallback>>>();
    private static Map<String, Map<String, DynamicPropAccessor>> propAccessorsMap;
    private List<String> propList;
    private static List<PropPatternProcessor> patternProcessorList;

    public PropConfig() {
        log.info("init Configuration");
    }

    public static String getMetaAppProperty(String name) {
        return ServiceUtil.getAppProperty(name);
    }

    public static void addPatternProcessor(PropPatternProcessor patternProcessor) {
        patternProcessorList.add(patternProcessor);
    }

    public static String getAppId() {
        return ServiceUtil.getAppId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropConfig getInstance() {
        if (propConfig != null) return propConfig;
        Class<PropConfig> clazz = PropConfig.class;
        synchronized (PropConfig.class) {
            if (propConfig != null) return propConfig;
            propConfig = new PropConfig();
            propConfig.initializeProperties(new Properties());
            // ** MonitorExit[var0] (shouldn't be in output)
            return propConfig;
        }
    }

    public void mergeLocalConfigSource(Map<?, ?> map) {
        if (MERGED.compareAndSet(false, true)) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.props.put(entry.getKey(), entry.getValue().toString());
            }
        }
    }

    public static <T> T getProperties(String key, Class<T> clazz) {
        String content = PropConfig.getInstance().getProperty(key);
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(content);
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return (T)Integer.valueOf(content);
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return (T)Long.valueOf(content);
        }
        return (T)content;
    }

    public static <T> List<T> getListProperties(String key, Class<T> clazz) {
        String content = PropConfig.getInstance().getProperty(key);
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            return JSON.parseArray((String)content, clazz);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u6210List\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public static String getProperties(String key) {
        return PropConfig.getInstance().getProperty(key);
    }

    public static String getProperties(String key, String defaultValue) {
        return PropConfig.getInstance().getProperty(key, defaultValue);
    }

    public static Object setProperties(String key, String value) {
        return PropConfig.getInstance().setProperty(key, value);
    }

    public void setBootEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    private String getPrioritizedProperty(Properties properties, String key, String defaultValue) {
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            Object obj;
            if (this.props != null && (obj = this.props.get(key)) != null) {
                return obj.toString();
            }
            if (StringUtils.isEmpty((CharSequence)value) && StringUtils.isEmpty((CharSequence)(value = properties.getProperty(key))) && StringUtils.isEmpty((CharSequence)(value = ServiceUtil.getServerSideAppProperty(key))) && StringUtils.isEmpty((CharSequence)(value = ServiceUtil.getServerSideProperty(key))) && StringUtils.isEmpty((CharSequence)(value = PropConfig.getMetaAppProperty(key))) && StringUtils.isEmpty((CharSequence)(value = System.getenv(key)))) {
                value = defaultValue;
            }
        }
        return value;
    }

    private String getPrioritizedProperty(Properties properties, String key) {
        return this.getPrioritizedProperty(properties, key, null);
    }

    public static String getEnv(Properties properties) {
        String env = PropConfig.getInstance().getPrioritizedProperty(properties, ENV_KEY);
        if (StringUtils.isEmpty((CharSequence)env)) {
            return ENV_LOCAL;
        }
        return PropConfig.getApolloEnvName(env);
    }

    public static String getEnv() {
        return PropConfig.getEnv(System.getProperties());
    }

    public static String getApolloCluster(Properties properties) {
        String cluster = PropConfig.getInstance().getPrioritizedProperty(properties, APOLLO_CLUSTER);
        if (StringUtils.isNotBlank((CharSequence)cluster)) {
            return cluster.trim();
        }
        return null;
    }

    public static String getApolloCluster() {
        return PropConfig.getApolloCluster(System.getProperties());
    }

    public List<String> getNamespaces(ConfigMeta meta, Properties properties) {
        String namespaces = this.getPrioritizedProperty(properties, NAMESPACES_KEY);
        ArrayList<String> namespacesList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)namespaces)) {
            return namespacesList;
        }
        meta.namespaces = namespaces.trim();
        this.props.put(NAMESPACES_KEY, namespaces);
        if (StringUtils.isNotEmpty((CharSequence)namespaces)) {
            String[] nsArr;
            for (String ns : nsArr = namespaces.split(",")) {
                if (NAMESPACE_APPLICATION.equals(ns = ns.trim())) continue;
                namespacesList.add(ns);
            }
        }
        meta.namespaceList = namespacesList;
        return namespacesList;
    }

    Properties getProps() {
        return this.props;
    }

    private ConfigMeta getConfigMeta(Properties properties) {
        String metaUrl;
        String env = PropConfig.getEnv(properties);
        if (ENV_LOCAL.equals(env)) {
            return null;
        }
        String key = env + "_meta";
        ConfigMeta meta = new ConfigMeta();
        meta.metaName = key;
        this.getNamespaces(meta, properties);
        meta.metaUrl = metaUrl = this.getPrioritizedProperty(properties, key);
        return meta;
    }

    protected Properties initializeProperties(Properties sysProperties) {
        if (INITIALIZED.compareAndSet(false, true)) {
            log.info("---- start process properties ---");
            this.props = new Properties();
            String env = PropConfig.getEnv(sysProperties);
            this.setActiveProperty(ENV_KEY, env);
            String appId = PropConfig.getAppId();
            String cluster = PropConfig.getApolloCluster(sysProperties);
            this.setActiveProperty(APP_ID, appId);
            if (StringUtils.isNotEmpty((CharSequence)cluster)) {
                this.setActiveProperty(APOLLO_CLUSTER, cluster);
            }
            this.meta = this.readConfig(env, sysProperties);
            this.printAllProperties();
            propConfig = this;
            this.matchAndProcessProps(this.props);
        }
        return this.props;
    }

    private void matchAndProcessProps(Properties props) {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            final String name = (String)enumeration.nextElement();
            for (final PropPatternProcessor patternProcessor : patternProcessorList) {
                if (!patternProcessor.isMatch(name)) continue;
                String value = props.getProperty(name);
                patternProcessor.process(name, value);
                PropConfig.addPropChangeCallback(name, new PropChangeCallback(){

                    @Override
                    public void onChange(PropChange propChange) {
                        patternProcessor.process(name, propChange.getNewValue());
                    }
                });
            }
        }
    }

    private void setActiveProperty(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.props.setProperty(name, value);
        System.setProperty(name, value);
    }

    private boolean canPrintProperties() {
        if (this.printed) {
            return false;
        }
        String configLogEnable = System.getProperty("config.log.enable");
        if (configLogEnable == null || !"false".equals(configLogEnable.toLowerCase())) {
            if (ENV_LOCAL.equals(PropConfig.getEnv())) {
                return MERGED.get() && PRINTED.compareAndSet(false, true);
            }
            return PRINTED.compareAndSet(false, true);
        }
        return false;
    }

    public void printAllProperties() {
        if (this.canPrintProperties()) {
            String env = PropConfig.getEnv();
            String appId = PropConfig.getAppId();
            String cluster = PropConfig.getApolloCluster();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("@****************************************************************************************@\n");
            stringBuilder.append("@                               * THE BEAST CONFIGURATION *                              @\n");
            stringBuilder.append("@****************************************************************************************@\n");
            stringBuilder.append("\n");
            stringBuilder.append("------------------------------------ Service META INFO -----------------------------------\n");
            stringBuilder.append("|\n");
            stringBuilder.append("|   Environment : " + this.getPrintableEnvName(env) + "\n");
            stringBuilder.append("|   App ID : " + appId + "\n");
            if (StringUtils.isNotEmpty((CharSequence)cluster)) {
                stringBuilder.append("|   Apollo Cluster : " + cluster + "\n");
            }
            if (this.meta != null) {
                if (this.meta.metaName != null) {
                    stringBuilder.append("|   Meta Name : " + this.meta.metaName + "\n");
                }
                if (this.meta.metaUrl != null) {
                    stringBuilder.append("|   Meta URL : " + this.meta.metaUrl + "\n");
                }
                if (this.meta.namespaceList != null) {
                    stringBuilder.append("|   Namespaces : " + StringUtils.join(this.meta.namespaceList, (String)", ") + "\n");
                }
            }
            this.printAllProperties(this.meta, stringBuilder);
            stringBuilder.append("|\n");
            stringBuilder.append("@****************************************************************************************@\n");
            log.info("init properties:\n\n" + stringBuilder);
            this.printed = true;
        }
    }

    private void printAllProperties(ConfigMeta meta, StringBuilder stringBuilder) {
        Properties cache = new Properties();
        for (String key : meta.properties.keySet()) {
            Properties properties = meta.properties.get(key);
            this.printProperties(properties, "Namespace: " + key, stringBuilder, cache);
        }
        Iterator<Map.Entry<Object, Object>> pIt = this.props.entrySet().iterator();
        Properties otherProps = new Properties();
        while (pIt.hasNext()) {
            Map.Entry<Object, Object> entry = pIt.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (cache.containsKey(key)) continue;
            otherProps.put(key, value);
        }
        this.printProperties(otherProps, "Other Properties", stringBuilder, null);
    }

    private void printProperties(Properties properties, String title, StringBuilder stringBuilder, Properties cache) {
        if (properties.size() == 0) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
        stringBuilder.append("|\n");
        stringBuilder.append("------------------------------------ " + title + " -----------------------------------\n");
        stringBuilder.append("|\n");
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (cache != null) {
                cache.put(key, value);
            }
            stringBuilder.append("|   " + key + " = " + value + "\n");
        }
    }

    private static String getApolloEnvName(String env) {
        if (ENV_TEST.equals(env)) {
            return APOLLO_FAT;
        }
        if (ENV_PRE.equals(env)) {
            return APOLLO_UAT;
        }
        if (ENV_PROD.equals(env)) {
            return APOLLO_PRO;
        }
        return env;
    }

    private String getPrintableEnvName(String env) {
        String upEnv = env.toUpperCase();
        if (APOLLO_FAT.equals(env)) {
            return "TEST (FAT)";
        }
        if (APOLLO_UAT.equals(env)) {
            return "PRE (UAT)";
        }
        if (APOLLO_PRO.equals(env)) {
            return "PROD (PRO)";
        }
        return upEnv;
    }

    private ConfigMeta readConfig(String env, Properties properties) {
        ConfigMeta meta = null;
        meta = ENV_LOCAL.equals(env) ? this.readFromLocal(properties) : this.readFromApollo(properties);
        return meta;
    }

    private ConfigMeta readFromLocal(Properties properties) {
        ConfigMeta meta = new ConfigMeta();
        meta.metaName = "local config";
        meta.namespaces = "Local Config";
        meta.namespaceList = Lists.newArrayList((Object[])new String[]{"Local Config"});
        Properties nsProps = new Properties();
        meta.properties.put(meta.namespaces, nsProps);
        for (Map.Entry<Object, Object> propIt : properties.entrySet()) {
            if (this.props.containsKey(propIt.getKey())) continue;
            String key = propIt.getKey().toString();
            Object value = propIt.getValue();
            this.props.put(key, value);
            nsProps.put(key, value);
        }
        return meta;
    }

    private ConfigMeta readFromApollo(Properties properties) {
        ConfigMeta meta = this.getConfigMeta(properties);
        if (meta != null) {
            this.props.put(meta.metaName, meta.metaUrl);
            System.setProperty(meta.metaName, meta.metaUrl);
        }
        this.readApolloConfig(NAMESPACE_APPLICATION, meta, ConfigService.getAppConfig());
        this.addDefaultPropertiesChangeListener();
        if (meta.namespaceList != null) {
            for (String namespace : meta.namespaceList) {
                this.readApolloConfig(namespace, meta, ConfigService.getConfig((String)namespace));
                this.addDefaultPropertiesChangeListener(namespace);
            }
        }
        return meta;
    }

    private void readApolloConfig(String namespace, ConfigMeta meta, Config config) {
        Properties properties = meta.properties.get(namespace);
        if (properties == null) {
            properties = new Properties();
            meta.properties.put(namespace, properties);
        }
        Set names = config.getPropertyNames();
        for (String name : names) {
            if (this.props.containsKey(name)) continue;
            String value = config.getProperty(name, null);
            this.namespaceMap.put(name, namespace);
            this.props.setProperty(name, value);
            properties.setProperty(name, value);
        }
    }

    public String getProperty(String key) {
        return this.getPrioritizedProperty(this.props, key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, Object value) {
        return this.props.setProperty(key, value.toString());
    }

    public static Properties getPropertiesObj() {
        return PropConfig.getInstance().getProps();
    }

    private PropConfig addPropertiesChangeListener(String namespace, final PropChangeListener listener) {
        Config config = null;
        config = StringUtils.isBlank((CharSequence)namespace) || namespace.equals(NAMESPACE_APPLICATION) ? ConfigService.getAppConfig() : ConfigService.getConfig((String)namespace);
        config.addChangeListener(new ConfigChangeListener(){

            public void onChange(ConfigChangeEvent changeEvent) {
                ApolloPropChangeEvent propChangeEvent = new ApolloPropChangeEvent(changeEvent);
                listener.onChange(propChangeEvent);
            }
        });
        return this;
    }

    private PropConfig addDefaultPropertiesChangeListener(String namespace) {
        log.info("%%%% \u6dfb\u52a0Apollo\u914d\u7f6e\u76d1\u542c\u5668 [Namespace: " + namespace + "] %%%%");
        return this.addPropertiesChangeListener(namespace, new PropChangeListener(){

            @Override
            public void onChange(PropChangeEvent event) {
                List<String> propNames = event.getPropNames();
                log.info("%%% Apollo\u914d\u7f6e\u53d1\u751f\u6539\u53d8 %%%");
                log.info("%%% namespace: " + event.getNamespace());
                log.info("%%% propNames: " + propNames);
                String namespace = event.getNamespace();
                Map propChangeCallbackPropNameMap = (Map)PropConfig.this.propChangeCallbackMap.get(namespace);
                for (String propName : propNames) {
                    Map callbackBeanMap;
                    PropChange change = event.getChange(propName);
                    if (change == null) continue;
                    log.info("%%% Change Property: [Prop Name: " + change.getName() + "] [New Value: " + change.getNewValue() + "] [Old Value: " + change.getOldValue() + "]");
                    PropConfig.this.props.setProperty(change.getName(), change.getNewValue());
                    Map propAccessorBeanMap = (Map)propAccessorsMap.get(propName);
                    if (MapUtils.isNotEmpty((Map)propAccessorBeanMap)) {
                        for (DynamicPropAccessor propAccessor : propAccessorBeanMap.values()) {
                            propAccessor.refreshValue();
                        }
                    }
                    if (propChangeCallbackPropNameMap == null || !MapUtils.isNotEmpty((Map)(callbackBeanMap = (Map)propChangeCallbackPropNameMap.get(propName)))) continue;
                    for (PropChangeCallback callback : callbackBeanMap.values()) {
                        callback.onChange(change);
                    }
                }
            }
        });
    }

    private PropConfig addDefaultPropertiesChangeListener() {
        return this.addDefaultPropertiesChangeListener(NAMESPACE_APPLICATION);
    }

    public PropConfig addPropertiesChangeCallback(String namespace, String propName, PropChangeCallback callback) {
        return this.addPropertiesChangeCallback("default", namespace, propName, callback);
    }

    public PropConfig addPropertiesChangeCallback(String beanId, String namespace, String propName, PropChangeCallback callback) {
        Map<String, PropChangeCallback> callbackBeanMap;
        if (namespace == null && StringUtils.isBlank((CharSequence)(namespace = this.namespaceMap.get(propName)))) {
            namespace = NAMESPACE_APPLICATION;
        }
        if (ENV_LOCAL.equals(this.props.get(ENV_KEY))) {
            return this;
        }
        log.info("%%%% \u6dfb\u52a0\u914d\u7f6e\u76d1\u542c\u56de\u8c03\u65b9\u6cd5: [Namespace: " + namespace + "] [propName: " + propName + "] %%%%");
        Map<String, Map<String, PropChangeCallback>> propChangeCallbackPropNameMap = this.propChangeCallbackMap.get(namespace);
        if (propChangeCallbackPropNameMap == null) {
            propChangeCallbackPropNameMap = new HashMap<String, Map<String, PropChangeCallback>>();
            this.propChangeCallbackMap.put(namespace, propChangeCallbackPropNameMap);
        }
        if ((callbackBeanMap = propChangeCallbackPropNameMap.get(propName)) == null) {
            callbackBeanMap = new LinkedHashMap<String, PropChangeCallback>();
            propChangeCallbackPropNameMap.put(propName, callbackBeanMap);
        }
        callbackBeanMap.put(beanId, callback);
        return this;
    }

    static void registerPropAccessor(String beanId, String propName, DynamicPropAccessor accessor) {
        Map<String, DynamicPropAccessor> propAccessorBeanMap = propAccessorsMap.get(propName);
        if (propAccessorBeanMap == null) {
            propAccessorBeanMap = new HashMap<String, DynamicPropAccessor>();
            propAccessorsMap.put(propName, propAccessorBeanMap);
        }
        propAccessorBeanMap.put(beanId, accessor);
    }

    public static void addPropChangeCallback(String beanId, String propName, PropChangeCallback callback) {
        propConfig.addPropertiesChangeCallback(beanId, null, propName, callback);
    }

    public static void addPropChangeCallback(String propName, PropChangeCallback callback) {
        propConfig.addPropertiesChangeCallback(null, propName, callback);
    }

    static {
        propAccessorsMap = new HashMap<String, Map<String, DynamicPropAccessor>>();
        patternProcessorList = new ArrayList<PropPatternProcessor>();
        ServiceLoader<PropPatternProcessor> loader = ServiceLoader.load(PropPatternProcessor.class);
        if (loader != null) {
            for (PropPatternProcessor processor : loader) {
                patternProcessorList.add(processor);
            }
        }
    }

    private static class ConfigMeta {
        public String metaName;
        public String metaUrl;
        public String namespaces;
        public List<String> namespaceList;
        public Map<String, Properties> properties = new LinkedHashMap<String, Properties>();
        public Properties otherProperties = new Properties();

        private ConfigMeta() {
        }
    }
}

