package com.thebeastshop.kit.prop.springboot;


import com.thebeastshop.kit.prop.PropPropertiesSource;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2019-03-06 19:04
 */
public class PropContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {

    @Override
    public void initialize(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        this.initializeSystemProperty(environment);
    }

    void initializeSystemProperty(ConfigurableEnvironment environment) {
        if (!environment.getPropertySources().contains("PropBootstrapPropertySources")) {
            CompositePropertySource composite = new CompositePropertySource("PropBootstrapPropertySources");
            composite.addPropertySource(new PropPropertiesSource("PropSource"));
            environment.getPropertySources().addFirst(composite);
        }
    }


}
