package com.thebeastshop.kit.prop;

import com.ctrip.framework.apollo.Config;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.StringUtils;

import java.util.Properties;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2019-03-06 19:15
 */
public class PropPropertiesSource extends EnumerablePropertySource<Config> {

    public PropPropertiesSource(String name) {
        super(name);
    }

    @Override
    public String[] getPropertyNames() {
        Properties properties = PropConfig.getPropertiesObj();
        if (properties == null) return new String [0];
        return StringUtils.toStringArray(properties.stringPropertyNames());
    }

    @Override
    public Object getProperty(String name) {
        return PropConfig.getProperties(name);
    }
}
