/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.kafka.producer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class KafkaProducerClient {
    private KafkaTemplate kafkaTemplate;

    public KafkaProducerClient(KafkaTemplate kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    public KafkaProducerClient() {
    }

    public void send(Object t) {
        this.send(this.kafkaTemplate.getDefaultTopic(), t);
    }

    public void send(String topic, Object t) {
        this.send(topic, null, t, false, null);
    }

    public void send(String topic, String key, Object t) {
        this.send(topic, key, t, false, null);
    }

    public void send(String topic, List<?> list) {
        for (Object t : list) {
            this.send(topic, t);
        }
    }

    public void sendWithCallback(String topic, Object t, ListenableFutureCallback<SendResult<String, String>> callback) {
        this.send(topic, null, t, false, callback);
    }

    public void sendWithCallback(String topic, String key, Object t, ListenableFutureCallback<SendResult<String, String>> callback) {
        this.send(topic, key, t, false, callback);
    }

    public void sendWithClass(Object t) {
        this.sendWithClass(this.kafkaTemplate.getDefaultTopic(), t);
    }

    public void sendWithClass(String topic, Object t) {
        this.send(topic, null, t, true, null);
    }

    public void sendWithClass(String topic, String key, Object t) {
        this.send(topic, key, t, true, null);
    }

    public void sendWithClass(String topic, List<?> list) {
        for (Object t : list) {
            this.sendWithClass(topic, t);
        }
    }

    public void sendWithClassAndCallback(String topic, Object t, ListenableFutureCallback<SendResult<String, String>> callback) {
        this.send(topic, null, t, true, callback);
    }

    public void sendWithClassAndCallback(String topic, String key, Object t, ListenableFutureCallback<SendResult<String, String>> callback) {
        this.send(topic, key, t, true, callback);
    }

    private void send(String topic, String key, Object t, boolean writeClass, ListenableFutureCallback callback) {
        ListenableFuture future = writeClass ? this.kafkaTemplate.send(topic, (Object)key, (Object)JSON.toJSONString((Object)t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName})) : this.kafkaTemplate.send(topic, (Object)key, (Object)JSON.toJSONString((Object)t));
        if (callback != null) {
            future.addCallback(callback);
        }
    }

    public KafkaTemplate getKafkaTemplate() {
        return this.kafkaTemplate;
    }

    public void setKafkaTemplate(KafkaTemplate kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

