package com.thebeastshop.kit.kafka.consumer;

import com.alibaba.fastjson.JSON;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.MessageListener;

import java.lang.reflect.ParameterizedType;

public abstract class KafkaConsumerObjectListener<V> implements MessageListener<String, V> {
    private final Logger log = LoggerFactory.getLogger(getClass());

    /**
     * 重载GenericMessageListener.onMessage方法</BR>
     * 当消费者端监听到有新的消息进来会调用该方法</BR>
     * 然后会调用子类实现的processMessage抽象方法
     * @param record
     */
    @Override
    public void onMessage(ConsumerRecord<String,V> record) {
        log.info("receive message:" + JSON.toJSONString(record.value()));
        V v = record.value();
        this.processMessage(record.key(), v);
    }

    /**
     * 消息处理逻辑所在的方法，需要子类实现
     * @param key
     * @param v
     */
    public abstract void processMessage(String key,V v);
}
