package com.thebeastshop.kit.kafka.producer;

import com.alibaba.fastjson.JSON;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.concurrent.ListenableFuture;

import java.util.List;

/**
 * Kafka生产者客户端
 */
@SuppressWarnings(value={"unchecked", "rawtypes"})
public class KafkaProducerClient {

	private KafkaTemplate kafkaTemplate;

//	private ExecutorService threadPool = Executors.newFixedThreadPool(20);


	public KafkaProducerClient(KafkaTemplate kafkaTemplate) {
		this.kafkaTemplate = kafkaTemplate;
	}

	public KafkaProducerClient() {
	}

	/**
	 * 发送消息
	 * @param t 消息
	 * @param <T>
     * @return
     */
	public <T> boolean send(T t){
		return send(kafkaTemplate.getDefaultTopic(), t);
	}

	/**
	 * 发送消息
	 * @param topic 主题
	 * @param t 消息
	 * @param <T>
     * @return
     */
	public <T> boolean send(String topic,T t){
		return send(topic, null, t);
	}

	/**
	 * 批量发送消息
	 * @param topic 主题
	 * @param list 消息
	 * @param <T>
     */
	public <T> void send(String topic,List<T> list){
		for(T t : list){
			send(topic, t);
		}
	}

	/**
	 * 发送消息
	 * @param topic 主题
	 * @param key  键
	 * @param t 消息
	 * @param <T>
     * @return
     */
	public <T> boolean send(final String topic,final String key,final T t){
		ListenableFuture future = kafkaTemplate.send(topic, key, JSON.toJSONString(t));
		return future.isDone();
	}


	public KafkaTemplate getKafkaTemplate() {
		return kafkaTemplate;
	}

	public void setKafkaTemplate(KafkaTemplate kafkaTemplate) {
		this.kafkaTemplate = kafkaTemplate;
	}
}
