/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.kafka.springboot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.thebeastshop.common.spring.SpringAware;
import com.thebeastshop.common.utils.MetaUtil;
import com.thebeastshop.kit.kafka.springboot.SbootKafkaConsumerVO;
import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import com.thebeastshop.kit.prop.PropConstants;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.kafka.listener.MessageListener;

public class KafkaConsumerStarter
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";
    private static final String KAFKA_CONSUMER_CONFIG = "kafka.consumer.config";

    public void afterPropertiesSet() throws Exception {
        String consumerConfig = PropConstants.getProperties((String)KAFKA_CONSUMER_CONFIG);
        if (StringUtils.isNotBlank((CharSequence)consumerConfig)) {
            try {
                TypeReference<List<SbootKafkaConsumerVO>> typeReference = new TypeReference<List<SbootKafkaConsumerVO>>(){};
                List consumerConfigList = (List)JSON.parseObject((String)consumerConfig, (TypeReference)typeReference, (Feature[])new Feature[0]);
                for (SbootKafkaConsumerVO configItem : consumerConfigList) {
                    KafkaDriver kafkaDriver = KafkaDriver.drive(PropConstants.getProperties((String)KAFKA_BOOTSTRAP_SERVERS));
                    Class<?> clazz = Class.forName(configItem.getHandler());
                    MessageListener messageListener = (MessageListener)SpringAware.registerBean(clazz);
                    kafkaDriver.startConsumer(configItem.getTopic(), MetaUtil.APP_NAME, messageListener, configItem.getConcurrency());
                }
            }
            catch (Throwable t) {
                String errorMsg = "cannot parse consumer config";
                this.log.error(errorMsg, t);
                throw new RuntimeException(errorMsg);
            }
        }
    }
}

