package com.thebeastshop.kit.kafka.springboot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.thebeastshop.common.spring.SpringAware;
import com.thebeastshop.common.utils.MetaUtil;
import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import com.thebeastshop.kit.prop.PropConstants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.kafka.listener.MessageListener;

import java.util.List;

/**
 * @author Bryan.Zhang
 * @Date 2019-03-20
 */
public class KafkaConsumerStarter implements InitializingBean {

    private final Logger log = LoggerFactory.getLogger(getClass());

    private final static String KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";
    private final static String KAFKA_CONSUMER_CONFIG = "kafka.consumer.config";

    @Override
    public void afterPropertiesSet() throws Exception {
        String consumerConfig = PropConstants.getProperties(KAFKA_CONSUMER_CONFIG);
        if(StringUtils.isNotBlank(consumerConfig)){
            try{
                TypeReference<List<SbootKafkaConsumerVO>> typeReference = new TypeReference<List<SbootKafkaConsumerVO>>(){};
                List<SbootKafkaConsumerVO> consumerConfigList = JSON.parseObject(consumerConfig, typeReference);

                for(SbootKafkaConsumerVO configItem : consumerConfigList){
                    KafkaDriver kafkaDriver = KafkaDriver.drive(PropConstants.getProperties(KAFKA_BOOTSTRAP_SERVERS));
                    Class<MessageListener> clazz = (Class<MessageListener>)Class.forName(configItem.getHandler());
                    MessageListener messageListener = SpringAware.registerBean(clazz);
                    String group = configItem.getGroup()==null?MetaUtil.APP_NAME:configItem.getGroup();
                    log.info("开始启动kafka消费者{},监听的topic为{},组为{},模式为{},并行数量为{}",
                            configItem.getHandler(),
                            configItem.getTopic(),
                            group,
                            configItem.getAckMode(),
                            configItem.getConcurrency());
                    kafkaDriver.startConsumer(configItem.getTopic(), group, messageListener, configItem.getConcurrency(), configItem.getAckMode());
                }
            }catch(Throwable t){
                String errorMsg = "cannot parse consumer config";
                log.error(errorMsg,t);
                throw new RuntimeException(errorMsg);
            }
        }
    }
}
