package com.thebeastshop.kit.kafka.springboot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.thebeastshop.common.utils.MetaUtil;
import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import com.thebeastshop.kit.prop.PropConstants;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.kafka.listener.MessageListener;

import java.util.List;

/**
 * @author Bryan.Zhang
 * @Date 2019-03-20
 */
public class KafkaConsumerStarter implements InitializingBean {

    private final static String KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";
    private final static String KAFKA_CONSUMER_CONFIG = "kafka.consumer.config";

    @Override
    public void afterPropertiesSet() throws Exception {
        String consumerConfig = PropConstants.getProperties(KAFKA_CONSUMER_CONFIG);
        if(StringUtils.isNotBlank(consumerConfig)){
            try{
                TypeReference<List<SbootKafkaConsumerVO>> typeReference = new TypeReference<List<SbootKafkaConsumerVO>>(){};
                List<SbootKafkaConsumerVO> consumerConfigList = JSON.parseObject(consumerConfig, typeReference);

                for(SbootKafkaConsumerVO configItem : consumerConfigList){
                    KafkaDriver kafkaDriver = KafkaDriver.drive(PropConstants.getProperties(KAFKA_BOOTSTRAP_SERVERS));
                    Class<MessageListener> clazz = (Class<MessageListener>)Class.forName(configItem.getHandler());
                    MessageListener messageListener = clazz.newInstance();
                    kafkaDriver.startConsumer(configItem.getTopic(), MetaUtil.APP_NAME,messageListener,configItem.getConcurrency());
                }
            }catch(Throwable t){
                t.printStackTrace();
                throw new RuntimeException("cannot parse consumer config");
            }
        }
    }
}
