package com.thebeastshop.common.converter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-05-02 14:28
 */
public class ConverterSupport {

    private final static Map<Class<?>, ToList> fromMap = new HashMap<>();

    public static <T> ToList<T> from(Class<T> source) {
        synchronized (GenericBeanConverter.class) {
            ToList<T> toList = fromMap.get(source);
            if (toList != null) {
                return toList;
            }
            toList = new ToList<>();
            fromMap.put(source, toList);
            return toList;
        }
    }

    public static BeanConverterHandlerManager matchHandlerManager(Class<?> fromClass, Class<?> toClass) {
        ToList toList = fromMap.get(fromClass);
        if (toList != null) {
            BeanConverterHandlerManager handlerManager = toList.get(toClass);
            return handlerManager;
        }
        if (fromClass.equals(Object.class)) {
            return null;
        }
        return matchHandlerManager(fromClass.getSuperclass(), toClass);
    }

}
