/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.utils.EmptyUtil;
import java.math.BigDecimal;
import java.util.Random;

public class StringUtil {
    public static final String randomCharAndInts = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final String randomChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String randomInts = "0123456789";

    public static String getRandomString(int length) {
        return StringUtil.getRandomString(length, randomCharAndInts);
    }

    public static String getRandomString(int length, String randomChars) {
        Random random = new Random();
        int randomCharsLength = randomChars.length();
        StringBuffer sf = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            sf.append(randomChars.charAt(random.nextInt(randomCharsLength)));
        }
        return sf.toString();
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static String nativeToUnicode(String s) {
        if (EmptyUtil.isEmpty(s)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            sb.append("\\u" + Integer.toHexString(c));
        }
        return sb.toString();
    }

    public static String unicodeToNative(String s) {
        if (EmptyUtil.isEmpty(s)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = -1;
        int pos = 0;
        while ((i = s.indexOf("\\u", pos)) != -1) {
            sb.append(s.substring(pos, i));
            if (i + 5 >= s.length()) continue;
            pos = i + 6;
            sb.append((char)Integer.parseInt(s.substring(i + 2, i + 6), 16));
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static boolean isValidLong(String str) {
        try {
            long _v = Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isBigDecimal(String str) {
        try {
            BigDecimal bd = new BigDecimal(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String queryCallbackStr(String value) {
        if (EmptyUtil.isNotEmpty(value) && value.indexOf("[") > -1 && value.indexOf("]") > value.indexOf("[")) {
            return value.substring(1, value.indexOf(93));
        }
        return null;
    }

    public static String get(String str) {
        return str == null ? "" : str;
    }

    public static String substrForSquareBrackets(String value) {
        return StringUtil.isContainsSquareBrackets(value) ? value.substring(1, value.indexOf(93)) : value;
    }

    public static boolean isContainsSquareBrackets(String value) {
        int leftIdx = value.indexOf("[");
        int rightIdx = value.indexOf("]");
        return EmptyUtil.isNotEmpty(value) && leftIdx > -1 && rightIdx > leftIdx;
    }
}

