package com.thebeastshop.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPHelper {

	public static String zipAndSerialize(String str) throws Exception{
		return Base64Utils.simpleEncode(GZIPHelper.zip(str.getBytes()));
	}

	public static String deserializeAndUnzip(String str) throws Exception{
		return new String(GZIPHelper.unzip(Base64Utils.simpleDecode(str)));
	}

	public static byte[] zip(byte[] value) throws IOException {
		ByteArrayOutputStream output = null;
		GZIPOutputStream zip = null;

		byte[] arg2;
		try {
			output = new ByteArrayOutputStream();
			zip = new GZIPOutputStream(output);
			zip.write(value, 0, value.length);
			zip.close();
			arg2 = output.toByteArray();
		} finally {
			if (zip != null) {
				zip.close();
			}

			if (output != null) {
				output.close();
			}

		}

		return arg2;
	}

	public static byte[] unzip(byte[] value) throws IOException {
		ByteArrayOutputStream output = null;
		ByteArrayInputStream input = null;
		GZIPInputStream zip = null;

		try {
			output = new ByteArrayOutputStream();
			input = new ByteArrayInputStream(value);
			zip = new GZIPInputStream(input);
			byte[] buffer = new byte[1024];

			int read;
			while ((read = zip.read(buffer)) > 0) {
				output.write(buffer, 0, read);
			}

			byte[] arg5 = output.toByteArray();
			return arg5;
		} finally {
			if (zip != null) {
				zip.close();
			}

			if (output != null) {
				output.close();
			}

			if (input != null) {
				input.close();
			}

		}
	}
}
