package com.thebeastshop.common.cat;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-10-30 16:12
 */
public class RestCat {

    public static final String HEADER_ROOT = "cat-root-message-id";
    public static final String HEADER_PARENT = "cat-parent-message-id";
    public static final String HEADER_CHILD = "cat-child-message-id";

    public static final String CAT_ROOT = "_catRootMessageId";
    public static final String CAT_PARENT = "_catParentMessageId";
    public static final String CAT_CHILD = "_catChildMessageId";

    private static final String APPLICATION_KEY = "_application";

    private static final String HTTP_CALL_SERVER_APP = "HttpServer.app";
    public static final String HTTP_CALL_SERVER_CLIENT = "HttpServer.client";


    private static final String CAT_TYPE_HTTP_CALL = "HttpCall";
    private static final String CAT_TYPE_HTTP_CALL_APP = "HttpCall.app";
    private static final String CAT_TYPE_HTTP_CALL_SERVER = "HttpCall.server";
    private static final String CAT_TYPE_HTTP_CALL_PORT = "HttpCall.port";


    private static final ThreadLocal<Cat.Context> CAT_CONTEXT = new ThreadLocal<Cat.Context>();


    public static Transaction newClientTransaction(String name) {
        Transaction transaction = Cat.newTransaction(CAT_TYPE_HTTP_CALL, name);
        return transaction;
    }


    public static void createClientCross(String host, String port, Transaction transaction, String serverAppId) {
        Event crossAppEvent = Cat.newEvent(CAT_TYPE_HTTP_CALL_APP, serverAppId);
        Event crossServerEvent = Cat.newEvent(CAT_TYPE_HTTP_CALL_SERVER, host);
        Event crossPortEvent = Cat.newEvent(CAT_TYPE_HTTP_CALL_PORT, port);
        crossAppEvent.setStatus(Event.SUCCESS);
        crossServerEvent.setStatus(Event.SUCCESS);
        crossPortEvent.setStatus(Event.SUCCESS);
        completeEvent(crossAppEvent);
        completeEvent(crossPortEvent);
        completeEvent(crossServerEvent);
        transaction.addChild(crossAppEvent);
        transaction.addChild(crossPortEvent);
        transaction.addChild(crossServerEvent);
    }


    public static void createServerCross(HttpServletRequest request, Transaction transaction){
        String consumerAppName = request.getHeader(APPLICATION_KEY);
        if (StringUtils.isEmpty(consumerAppName)) {
            return;
        }
        Event crossAppEvent = Cat.newEvent(HTTP_CALL_SERVER_APP, consumerAppName);
        Event crossServerEvent = Cat.newEvent(HTTP_CALL_SERVER_CLIENT, request.getRemoteHost());
        crossAppEvent.setStatus(Event.SUCCESS);
        crossServerEvent.setStatus(Event.SUCCESS);
        completeEvent(crossAppEvent);
        completeEvent(crossServerEvent);
        transaction.addChild(crossAppEvent);
        transaction.addChild(crossServerEvent);
    }


    private static void completeEvent(Event event){
        AbstractMessage message = (AbstractMessage) event;
        message.setCompleted(true);
    }


    public static void setClientHeader(HttpMethodBase httpMethod, Cat.Context context) {
        httpMethod.addRequestHeader(HEADER_ROOT, context.getProperty(CAT_ROOT));
        httpMethod.addRequestHeader(HEADER_CHILD, context.getProperty(CAT_CHILD));
        httpMethod.addRequestHeader(HEADER_PARENT, context.getProperty(CAT_PARENT));
    }



    public static Cat.Context getServerSideContext(HttpServletRequest request) {
        Cat.Context context = CAT_CONTEXT.get();
        if (context == null) {
            context = initServerSideContext(request);
            CAT_CONTEXT.set(context);
        }
        return context;
    }

    public static void removeContext() {
        CAT_CONTEXT.remove();
    }


    public static Cat.Context getClientSideContext() {
        Cat.Context context = CAT_CONTEXT.get();
        if (context == null) {
            context = new RestCatContext();
            CAT_CONTEXT.set(context);
        }
        return context;
    }


    private static Cat.Context initServerSideContext(HttpServletRequest request) {
        Cat.Context context = new RestCatContext();
        Enumeration<String> headerNames = request.getHeaderNames();
        if (headerNames != null && headerNames.hasMoreElements()) {
            for( ; headerNames.hasMoreElements(); ){
                String headerName = headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                if (HEADER_CHILD.equals(headerName)) {
                    context.addProperty(CAT_CHILD, headerValue);
                } else if (HEADER_ROOT.equals(headerName)) {
                    context.addProperty(CAT_ROOT, headerValue);
                } else if (HEADER_PARENT.equals(headerName)) {
                    context.addProperty(CAT_PARENT, headerValue);
                }
            }
        }
        return context;
    }

}
