package com.thebeastshop.common.zk;


import com.alibaba.fastjson.JSON;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

import java.lang.reflect.ParameterizedType;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2019-02-28 20:47
 */
public abstract class ZkChildrenListener<T> implements PathChildrenCacheListener {

    @Override
    public void childEvent(CuratorFramework curator, PathChildrenCacheEvent event) throws Exception {
        String str = new String(event.getData().getData());
        T data = JSON.parseObject(str, getClazz());
        switch (event.getType()) {
            case CHILD_ADDED:
                onChildAdded(data);
                break;
            case CHILD_UPDATED:
                onChildUpdated(data);
                break;
            case CHILD_REMOVED:
                onChildRemoved(data);
                break;
            default:
                break;
        }
    }

    private Class<T> getClazz(){
        return (Class <T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }


    public abstract void onChildAdded(T data);

    public abstract void onChildUpdated(T data);

    public abstract void onChildRemoved(T data);

}
