/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.utils;

import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.io.*;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/**
 * xml工具类
 *
 * @author Paul-xiong
 * @date 2018年3月22日
 * @description
 */
public class XmlUtil {

	public static String toXml(Object obj) throws Exception {
		String xml = "";
		JAXBContext context = JAXBContext.newInstance(obj.getClass());
		Marshaller marshaller = context.createMarshaller();
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		marshaller.marshal(obj, os);
		xml = os.toString("utf-8");
		return xml;
	}

	@SuppressWarnings("unchecked")
	public static <T> T toObject(String xml, Class<T> clazz) throws Exception {
		T obj = null;
		JAXBContext context = JAXBContext.newInstance(clazz);
		Unmarshaller unmarshaller = context.createUnmarshaller();
		byte[] buf = xml.getBytes("UTF-8");
		obj = (T) unmarshaller.unmarshal(new ByteArrayInputStream(buf));
		return obj;
	}
	/**
	 * xmlToString
	 * @return String
	 */
	public static String xmlToString(InputStreamReader in){
		BufferedReader reader = new BufferedReader(in);
		StringBuffer sb = new StringBuffer();
		String line = null;
		try {
			while ((line = reader.readLine()) != null)
			{  //处理换行符
				sb.append(line + "\r\n");
			}
		} catch (IOException e){
			e.printStackTrace();
		} finally{
			try
			{
				in.close();
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
		return sb.toString();
	}

	public static String xmlToString(InputStream in){
		String responseString = null;
		BufferedInputStream bis = null;
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		try{
			bis = new BufferedInputStream(in);
			byte[] bytes = new byte[1024];
			int count;
			while((count = bis.read(bytes))!= -1){
				bos.write(bytes, 0, count);
			}
			byte[] strByte = bos.toByteArray();
			responseString = new String(strByte, 0, strByte.length, "utf-8");
		}catch (IOException e){
			try {
				bos.close();
				bis.close();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
		return responseString;
	}

	public static <T> T fromXML(String xml, Class<T> valueType) throws JAXBException {
		T message = null;
		try {
			JAXBContext context = JAXBContext.newInstance(valueType);
			Unmarshaller unmarshaller = context.createUnmarshaller();
			StringReader sr = new StringReader(xml);
			message = (T)unmarshaller.unmarshal(sr);
		}catch (JAXBException e) {
			e.printStackTrace();
		}
		return message;
	}

	/**
	 * @param express xpath express
	 * @param xml
	 * @return
	 * @throws
	 */
	public static String parseString(String express, String xml) throws XPathExpressionException {
		if (StringUtils.isNotBlank(xml)) {
			XPath xPath = getXPath();
			return (String) xPath.evaluate(express, new InputSource(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8))), XPathConstants.STRING);
		}
		return null;
	}

	/**
	 * @param express xpath express
	 * @param xml
	 * @return
	 * @throws XPathExpressionException
	 */
	public static NodeList parseNodeList(String express, String xml) throws XPathExpressionException {
		if (StringUtils.isNotBlank(xml)) {
			XPath xPath = getXPath();
			return (NodeList) xPath.evaluate(express, new InputSource(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8))), XPathConstants.NODESET);
		}
		return null;
	}

	public static XPath getXPath() {
		return XPathFactory.newInstance().newXPath();
	}

	public static <T> List<T> getObjecList(String filePath, Class<T> clazz, String childNote) throws Exception{
		org.dom4j.Document doc = null;
		List<T> list = new ArrayList<>();
		try {
			SAXReader reader = new SAXReader(); //User.hbm.xml表示你要解析的xml文档
			doc = reader.read(new File(filePath));
			Element rootElt = doc.getRootElement(); // 获取根节点
//			log.info("root node:{}", rootElt.getName());
			Iterator<Element> it = rootElt.elementIterator(childNote);// 获取根节点下所有对应名称子节点
			while (it.hasNext()) {
				Element elementGroupService = (Element) it.next();
				T baseBean = (T) XmlUtil.fromXmlToBean(
						elementGroupService, clazz);
				list.add(baseBean);
			}
		} catch (DocumentException e) {
			e.printStackTrace();
//			.error("read document exception! {}", e);
		}
		return list;
	}

	public static Object fromXmlToBean(Element rootElt, Class clazz) throws Exception{
		Field[] fields = clazz.getDeclaredFields();
		Object obj = clazz.newInstance();
		try {
			for (Field field : fields) {
				// 设置字段可访问（必须，否则报错）
				field.setAccessible(true);
				// 得到字段的属性名
				String name = field.getName();
				// 这一段的作用是如果字段在Element中不存在会抛出异常，如果出异常，则跳过。
				rootElt.elementTextTrim(name);
				if (rootElt.elementTextTrim(name) != null && !"".equals(rootElt.elementTextTrim(name))) {
					// 根据字段的类型将值转化为相应的类型，并设置到生成的对象中。
					if (field.getType().equals(Long.class) || field.getType().equals(long.class)) {
						field.set(obj, Long.parseLong(rootElt.elementTextTrim(name)));
					} else if (field.getType().equals(String.class)) {
						field.set(obj, rootElt.elementTextTrim(name));
					} else if (field.getType().equals(Double.class) || field.getType().equals(double.class)) {
						field.set(obj, Double.parseDouble(rootElt.elementTextTrim(name)));
					} else if (field.getType().equals(Integer.class) || field.getType().equals(int.class)) {
						field.set(obj, Integer.parseInt(rootElt.elementTextTrim(name)));
					} else if (field.getType().equals(java.util.Date.class)) {
						field.set(obj, Date.parse(rootElt.elementTextTrim(name)));
					} else {
						continue;
					}
				}
			}
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		return obj;
	}
}
