package com.thebeastshop.common;

import com.google.common.base.CaseFormat;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;

/**
 *
 * @author Paul-xiong
 * @date 2018年8月8日
 * @description
 */
public abstract class BaseProto<T> implements ByteHandler {

	private static String GETTER_PREFIX = "get";

	private static String SETTER_PREFIX = "set";

	private Object protoBuilder;

	public BaseProto() {
		super();
		try {
			@SuppressWarnings("unchecked")
			Class<T> clazz = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
			Method method = clazz.getMethod("newBuilder");
			protoBuilder = method.invoke(null);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Object getProperty(String propertyName) {
		try {
			Method method = protoBuilder.getClass().getMethod(GETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName));
			return method.invoke(protoBuilder);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected void setProperty(String propertyName, Object propertyValue) {
		try {
			Method method = protoBuilder.getClass().getMethod(SETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName), propertyValue.getClass());
			method.invoke(protoBuilder, propertyValue);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public byte[] toByteArray() {
		try {
			Method method = protoBuilder.getClass().getMethod("build");
			Object proto = method.invoke(protoBuilder);
			return (byte[]) proto.getClass().getMethod("toByteArray").invoke(proto);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void mergeFrom(ByteBuffer byteBuffer) {
		try {
			@SuppressWarnings("unchecked")
			Class<T> clazz = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
			Object proto = clazz.getMethod("parseFrom", ByteBuffer.class).invoke(null, byteBuffer);
			protoBuilder.getClass().getMethod("mergeFrom", proto.getClass()).invoke(protoBuilder, proto);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
