package com.thebeastshop.common.converter;

import com.thebeastshop.common.enums.BooleanValue;
import com.thebeastshop.common.enums.CodeEnum;
import com.thebeastshop.common.exception.CodeEnumConvertException;
import com.thebeastshop.common.utils.EnumUtil;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-04-03 13:22
 */
public class BeanFieldConverter {


    public static Object convert(Object sourceObj, Class sourceType, Class targetType) {
        if (sourceObj == null) {
            return null;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return sourceObj;
        }
        if (Integer.class.isAssignableFrom(sourceType) && Boolean.class.isAssignableFrom(targetType)) {
            if ((Integer)sourceObj == 0) {
                return false;
            }
            return true;
        }
        if (Boolean.class.isAssignableFrom(sourceType) && Integer.class.isAssignableFrom(targetType)) {
            if ((Boolean)sourceObj == false) {
                return 0;
            }
            return 1;
        }
        if (sourceObj instanceof BooleanValue) {
            if (targetType.isAssignableFrom(Boolean.class) || targetType.isAssignableFrom(boolean.class)) {
                BooleanValue booleanValue = (BooleanValue) sourceObj;
                return booleanValue.toBooleanValue();
            }
        }
        if (sourceObj instanceof CodeEnum) {
            CodeEnum codeEnum = (CodeEnum)sourceObj;
            Object code = codeEnum.getCode();
            Class codeType = code.getClass();
            if (!targetType.isAssignableFrom(codeType)) {
                throw new CodeEnumConvertException(
                        sourceType.getName() +
                        "没有包含正确的泛型类型参数，CodeEnum<>泛型参数中的" +
                        codeType.getName() + "不能转换为" + targetType.getName());
            }
            return code;
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            if (BooleanValue.class.isAssignableFrom(targetType)) {
                if (Boolean.class.isAssignableFrom(sourceType) || boolean.class.isAssignableFrom(sourceType)) {
                    return EnumUtil.getByBooleanValue(targetType, (Boolean) sourceObj);
                }
            }
            if (CodeEnum.class.isAssignableFrom(targetType)) {
                Type[] interfaces = targetType.getGenericInterfaces();
                for (Type type : interfaces) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType) type;
                        Class rawType = (Class) parameterizedType.getRawType();
                        if (CodeEnum.class.isAssignableFrom(rawType)) {
                            Type[] argTypes = parameterizedType.getActualTypeArguments();
                            if (argTypes.length != 1) {
                                throw new CodeEnumConvertException(
                                        targetType.getName() +
                                                "没有包含正确的泛型类型参数");
                            }
                            Class argType = (Class) argTypes[0];
                            if (!argType.isAssignableFrom(sourceType)) {
                                throw new CodeEnumConvertException(
                                        targetType.getName() +
                                                "没有包含正确的泛型类型参数， " +
                                                sourceType.getName() +
                                                "无法转换为CodeEnum<>泛型参数中的" + argType.getName());
                            }
                            return EnumUtil.getByCode(targetType, sourceObj);
                        }
                    }
                }
            }
        }
        return null;
    }

}
