package com.thebeastshop.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Gary 实体对象fields变更日志记录
 * @param <T>
 */
public class CompareObejct<T> {

    private CompareStatus status;
    /**
     * 之前原始的值
     */
    private T original;
    /**
     * 当前的值
     */
    private T current;

    private Class<T> tClass;

    private StringBuilder changeStringBuilder;

    public CompareObejct(T original, T current, Class<T> tClass) {
      this.original = original;
      this.current = current;
      this.tClass = tClass;
    }

    public CompareObejct(T original, T current, Class<T> tClass, StringBuilder changeStringBuilder) {
        this.original = original;
        this.current = current;
        this.tClass = tClass;
        this.changeStringBuilder = changeStringBuilder;
    }


    public CompareStatus getStatus() {
        return status;
    }


    public T getOriginal() {
        return original;
    }


    public void setOriginal(T original) {
        this.original = original;
    }


    public T getCurrent() {
        return current;
    }


    public void setCurrent(T current) {
        this.current = current;
    }


    public String contrastObj() {
        if (changeStringBuilder == null) {
            changeStringBuilder = new StringBuilder();
        }
        boolean allIsEqual=true;
        try {
            if(this.original == null){
                this.status = CompareStatus.NEW;
                Field[] fields = tClass.getDeclaredFields();
                for (Field field : fields) {
                    ObjectChangeLog objectChangeLog = field.getAnnotation(ObjectChangeLog.class);
                    if (objectChangeLog != null) {
                        String filedName = objectChangeLog.name();
                        PropertyDescriptor pd = new PropertyDescriptor(field.getName(), tClass);
                        Method getMethod = pd.getReadMethod();
                        Object o2 = getMethod.invoke(this.current);
                        String s2 = o2 == null ? "" : o2.toString();//避免空指针异常
                        if (s2 != null && s2 != "") {
                            if (changeStringBuilder.length() != 0) {
                                changeStringBuilder.append(" | ");
                            }
                            changeStringBuilder.append("<font color=\"#FF0000\">" + filedName + "</font>：[" + s2 + "]");
                        }
                    }
                }
            } else {
                //Class clazz = this.original.getClass();
                Field[] fields = tClass.getDeclaredFields();
                for (Field field : fields) {
                     System.out.println(field.getName());
                    ObjectChangeLog objectChangeLog = field.getAnnotation(ObjectChangeLog.class);
                    if (objectChangeLog != null) {
                        String filedName = objectChangeLog.name();
                        String fieldTypeAnnotation = objectChangeLog.fieldType();
                        String fieldType = field.getType().getName();


                        PropertyDescriptor pd = new PropertyDescriptor(field.getName(), tClass);
                        Method getMethod = pd.getReadMethod();
                        Object o1 = this.original == null ? null : getMethod.invoke(this.original);
                        Object o2 = this.current == null ? null : getMethod.invoke(this.current);
                        //属性是对象
                        if (fieldTypeAnnotation != "" && fieldTypeAnnotation.equals("java.lang.Class")) {
                            if (o1 == null && o2 == null) {
                              continue;
                            }
                            CompareObejct compareObejct = new CompareObejct(o1, o2, o1 == null ? o2.getClass() : o1.getClass(), changeStringBuilder);
                            compareObejct.contrastObj();
                            System.out.println(o1.getClass().getClass());
                            continue;
                        }

                        if(fieldType != "") {
                          if (fieldType.equals("java.util.Date")) {
                            if (o1 == null && o2 == null) {
                              continue;
                            }
                            o1 = o1 != null ? DateUtil.format((Date) o1, DateUtil.DEFAULT_DATETIME_FORMAT) : o1;
                            o2 = o2 != null ? DateUtil.format((Date) o2, DateUtil.DEFAULT_DATETIME_FORMAT) : o2;
                          } else if (fieldType.equals("java.math.BigDecimal")) {

                          } else if (fieldType.equals("java.util.List")) {
                              if (o1 == null && o2 == null) {
                                  continue;
                              }
                              o1 = getChangeStringBuilder((List<?>) o1, objectChangeLog.getMethod());
                              o2 = getChangeStringBuilder((List<?>) o2, objectChangeLog.getMethod());
                          }
                        }

                        String s1 = o1 == null ? "" : o1.toString();//避免空指针异常
                        String s2 = o2 == null ? "" : o2.toString();//避免空指针异常
                        //思考下面注释的这一行：会bug的，虽然被try catch了，程序没报错，但是结果不是我们想要的
                        //if (!o1.toString().equals(o2.toString())) {
                         boolean isEqual = true;
                         if (fieldType.equals("java.math.BigDecimal")) {
                           if (s1.equals("") && !s2.equals("") || !s1.equals("") && s2.equals("")) {
                             isEqual = false;
                           } else if(!s1.equals("") && !s2.equals("")){
                             //（1.00 改成1.0 不算真正变动）
                             if (new BigDecimal(s1).compareTo(new BigDecimal(s2)) != 0) {
                               isEqual = false;
                             }
                           }
                         } else  {
                            //textList.add("不一样的属性：" + field.getName() + " 属性值：[" + s1 + "," + s2 + "]");
                            if (!s1.equals(s2)) {
                              isEqual = false;
                            }
                        }
                        if (!isEqual) {
                          allIsEqual = true;
                          //System.out.println("" + filedName + "：[" + s1 + "->" + s2 + "]");
                          if (changeStringBuilder.length() != 0) {
                            changeStringBuilder.append(" | ");
                          }
                          changeStringBuilder.append("<font color=\"#FF0000\">" + filedName + "</font>：[" + s1 + "->" + s2 + "]");
                        }
                    }

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if(allIsEqual){
            this.status=CompareStatus.NO_CHANGE;
        }else{
            this.status=CompareStatus.CHANGE;
        }
        return changeStringBuilder.toString();
    }

    private StringBuilder getChangeStringBuilder(List<?> list, String getMethod) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        StringBuilder logSb1 = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (Object child : list) {
                Method getChangeLog = child.getClass().getMethod(EmptyUtil.isEmpty(getMethod) ? "getChangeLog" : getMethod);
                Object changeLog = getChangeLog.invoke(child);
                logSb1.append(changeLog);
            }
        }
        return logSb1;
    }


    public static void main(String[] args) {
//        ParentClass p1 = new ParentClass();
//        ParentClass p2 = new ParentClass();
//        ChildClass c1 = new ChildClass();
//        c1.setFieldName("sku1");
//        List<ChildClass> list = new ArrayList<ChildClass>();
//        list.add(c1);
//        p2.setList(list);
//        CompareObejct compareObejct = new CompareObejct(p1, p2, ParentClass.class);
//        compareObejct.contrastObj();
    }

}
