package com.thebeastshop.common.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jxl.JXLException;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.RowsExceededException;

import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;

@Component("commonWriteExcel")
public class CommonWriteExcel extends AbstractWriteExcel {
	
	private static final long serialVersionUID = 4632293456287402204L;

	private List<String> errorMessages=new ArrayList<String>();
	
	private Method getErrorMsgMethod;
	
	private static final SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
	private static final SimpleDateFormat isoTimeFormat = new SimpleDateFormat("hh:mm:ss.SSSZ");
	private static final SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
	private static final SimpleDateFormat dateTimeFormatForFileName = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
	
	private List<String> headers=new ArrayList<String>();
	private List<Field> ecFields=new ArrayList<Field>();
	
	private File file;
	
	private WritableCellFormat boldText;
	private WritableCellFormat normalText;
	
	private Class<?> clazz;
	
	public static String FILE_PATH = File.separator + "data"+File.separator + "appdatas";
	
	@Override
	public List<String> getErrors() {
		return this.errorMessages;
	}

	@Override
	public boolean hasError() {
		return errorMessages.size()>0?true:false;
	}

	@Override
	public File getFile() {
		return this.file;
	}
	@Override
	public void write(Class<?> clazz,List<?> datas) {
		this.write(clazz, datas, null);
	}

	@Override
	public void write(Class<?> clazz,List<?> datas, String fileName) {
		this.clazz=clazz;
		this.errorMessages.clear();
		this.headers.clear();
		this.ecFields.clear();
		if(this.clazz != null){
			initHeadersAndEcFields();
		}
		if(hasError()) {
			return;
		}
		if(this.clazz != null){
			initErrorMessageMehtod();
		}
		File path=new File(FILE_PATH+File.separator+"import_invalid_excel"+File.separator+1);
		if(!path.exists()) {
			path.mkdirs();
		}
		if(fileName == null || "".equals(fileName)) {
			fileName=dateTimeFormatForFileName.format(new Date())+".xls";
		}else {
			fileName+=".xls";
		}
		file=new File(path,fileName);
		try {
			WritableWorkbook workbook=Workbook.createWorkbook(file);
			//粗体 11
			WritableFont boldFont= new WritableFont(WritableFont.ARIAL,WritableFont.DEFAULT_POINT_SIZE,WritableFont.BOLD);
			boldFont.setPointSize(11);
			//11
			WritableFont normalFont= new WritableFont(WritableFont.ARIAL,WritableFont.DEFAULT_POINT_SIZE,WritableFont.NO_BOLD);
			normalFont.setPointSize(11);
			boldText=new WritableCellFormat(boldFont);
			normalText=new WritableCellFormat(normalFont);
			WritableSheet s = workbook.createSheet("sheet1",0);
			writeHeader(s);
			writeContent(s,datas);
			workbook.write();
			workbook.close();
			
		} catch (IOException e) {
			errorMessages.add(e.getMessage());
			e.printStackTrace();
		} catch (WriteException e) {
			errorMessages.add(e.getMessage());
			e.printStackTrace();
		} catch (JXLException e) {
			errorMessages.add(e.getMessage());
			e.printStackTrace();
		}
			
	}
	
	private void initHeadersAndEcFields(){
		if(this.clazz==null){
			errorMessages.add("clazz不能为空!");
			return;
		}
		ExcelTemplate et=clazz.getAnnotation(ExcelTemplate.class);
		if(et==null){
			errorMessages.add(clazz.getName()+"不是excel模板类!");
			return;
		}
		Class<?> temp=clazz;
		List<Field> fieldsList=new ArrayList<Field>();
		while(temp!=null&&!temp.equals(Object.class)
				&&temp.getAnnotation(ExcelTemplate.class)!=null){
			Field []fs=temp.getDeclaredFields();
			for(int x=0;x<fs.length;x++){
				ExcelColumn ec=fs[x].getAnnotation(ExcelColumn.class);
				if(ec==null) {
					continue;
				}
				fieldsList.add(fs[x]);
			}
			temp=temp.getSuperclass();
		}
		for(int i=0;i<fieldsList.size();i++){
			Field tfield=fieldsList.get(i);
			ExcelColumn ec=tfield.getAnnotation(ExcelColumn.class);
			if(ec==null) {
				continue;
			}
			String columnName=ec.name().equals("")?tfield.getName():ec.name();
			ecFields.add(tfield);
			headers.add(columnName);
		}
		if(headers.size()<1){
			errorMessages.add("没有找到ExcelColumn!请检查模板类!");
			return;
		}
	}
	
	
	private int writeHeader(WritableSheet s) throws RowsExceededException, JXLException{
		int row=0;
		for(int i=0;i<headers.size();i++){
			Label l=new Label(i,0,headers.get(i),boldText);
			s.addCell(l);
		}
		return row+1;
	}
	
	private int writeContent(WritableSheet s,List<?> datas){
		try {
			for(int i=0;i<datas.size();i++){
				for(int j=0;j<ecFields.size();j++){
					Method method=clazz.getMethod(generateGetMethod(ecFields.get(j).getName()));
					Object obj=method.invoke(datas.get(i));
					if(obj instanceof Number){
						Number value=null;
						if(obj!=null)
							value=(Number)obj;
//						else 
//							value=0;
						jxl.write.Number n=new jxl.write.Number(j,i+1,value.doubleValue());
						s.addCell(n);
					}else{
						Label l=null;
						if(obj!=null&&ecFields.get(j).getType().getName().equals("java.util.Date")){
							DateTimeFormat dtf=ecFields.get(j).getAnnotation(DateTimeFormat.class);
							if(dtf==null||dtf.iso().equals(DateTimeFormat.ISO.NONE)){
								l=new Label(j,i+1,isoDateFormat.format((Date)obj),normalText);	
							}else{
								String df=chooseISODateFormat(dtf.iso(),(Date)obj);
								l=new Label(j,i+1,df,normalText);	
							}
						}else {
							l=new Label(j,i+1,obj==null?"":obj.toString(),normalText);
						}
						s.addCell(l);
					}
				}
				if(getErrorMessage(datas.get(i)).length()>0){
					Label l=new Label(ecFields.size(),i+1,getErrorMessage(datas.get(i)),normalText);
					s.addCell(l);
				}
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (JxlWriteException e) {
			e.printStackTrace();
		} catch (WriteException e) {
			e.printStackTrace();
		}
		return 0;
	}
	
	private String chooseISODateFormat(DateTimeFormat.ISO iso,Date date){
		if(iso.equals(DateTimeFormat.ISO.DATE)) {
			return isoDateFormat.format(date);
		}
		if(iso.equals(DateTimeFormat.ISO.TIME)) {
			return isoTimeFormat.format(date);
		}
		if(iso.equals(DateTimeFormat.ISO.DATE_TIME)) {
			return isoDateTimeFormat.format(date);
		}
		return "yyyy-MM-dd";
	}
	
	private void initErrorMessageMehtod(){
		Field []fields=clazz.getDeclaredFields();
		try {
			for(int i=0;i<fields.length;i++){
				ErrorMessage em=fields[i].getAnnotation(ErrorMessage.class);
				if(em==null) {
					continue;
				}
				getErrorMsgMethod=clazz.getMethod(generateGetMethod(fields[i].getName()));
				break;
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		}
	}
	
	private String getErrorMessage(Object obj){
		if(getErrorMsgMethod!=null){
			try {
				Object value=getErrorMsgMethod.invoke(obj);
				return value==null?"":value.toString();
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
		return "";
	}
	
	
	private String generateGetMethod(String fieldName){
		if(fieldName==null||fieldName.length()<1) {
			return "";
		}
		return "get"+fieldName.toUpperCase().charAt(0)+fieldName.substring(1);
	}
	
	public static void main(String[] args) {
		
		File path=new File("/import_invalid_excel/admin");
		if(!path.exists()) {
			path.mkdirs();
		}
		
		//System.out.println(path.getAbsolutePath());
		
	}
}

