package com.thebeastshop.kit.flowable;

import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.springframework.beans.factory.FactoryBean;

/**
 * @author Bryan.Zhang
 * @Date 2019-06-06
 */
public class FlowableEngineFactoryBean implements FactoryBean<FlowableEngine> {

    private String flowableJdbcUrl;

    private String flowableJdbcDriver;

    private String flowableJdbcUsername;

    private String flowableJdbcPassword;

    public FlowableEngineFactoryBean(String flowableJdbcUrl, String flowableJdbcDriver, String flowableJdbcUsername, String flowableJdbcPassword) {
        this.flowableJdbcUrl = flowableJdbcUrl;
        this.flowableJdbcDriver = flowableJdbcDriver;
        this.flowableJdbcUsername = flowableJdbcUsername;
        this.flowableJdbcPassword = flowableJdbcPassword;
    }

    @Override
    public FlowableEngine getObject() throws Exception {
        ProcessEngineConfiguration cfg = new StandaloneProcessEngineConfiguration()
                .setJdbcUrl(flowableJdbcUrl).setJdbcUsername(flowableJdbcUsername).setJdbcPassword(flowableJdbcPassword)
                .setJdbcDriver(flowableJdbcDriver)
                .setDatabaseSchemaUpdate(ProcessEngineConfiguration.DB_SCHEMA_UPDATE_TRUE);
        ProcessEngine processEngine = cfg.buildProcessEngine();
        return new FlowableEngine(processEngine);
    }

    @Override
    public Class<?> getObjectType() {
        return FlowableEngine.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
